/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import android.os.Build;
import android.os.Handler;
import android.util.Log;
import com.koushikdutta.async.AsyncDatagramSocket;
import com.koushikdutta.async.AsyncNetworkSocket;
import com.koushikdutta.async.AsyncServerSocket;
import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.ChannelWrapper;
import com.koushikdutta.async.ServerSocketChannelWrapper;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.ConnectCallback;
import com.koushikdutta.async.callback.ListenCallback;
import com.koushikdutta.async.future.Cancellable;
import com.koushikdutta.async.future.Future;
import com.koushikdutta.async.future.SimpleFuture;
import com.koushikdutta.async.future.TransformFuture;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class AsyncServer {
    public static final String LOGTAG = "NIO";
    private static WeakHashMap<Thread, ThreadQueue> mThreadQueues = new WeakHashMap();
    static AsyncServer mInstance;
    private boolean mAutoStart = false;
    private Selector mSelector;
    LinkedList<Scheduled> mQueue = new LinkedList();
    ExecutorService synchronousWorkers = Executors.newFixedThreadPool(4);
    static Hashtable<Thread, AsyncServer> mServers;
    Thread mAffinity;
    private static final long QUEUE_EMPTY = Long.MAX_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ThreadQueue getOrCreateThreadQueue(Thread thread) {
        ThreadQueue queue;
        WeakHashMap<Thread, ThreadQueue> weakHashMap = mThreadQueues;
        synchronized (weakHashMap) {
            queue = mThreadQueues.get(thread);
            if (queue == null) {
                queue = new ThreadQueue();
                mThreadQueues.put(thread, queue);
            }
        }
        return queue;
    }

    public static void post(Handler handler, Runnable runnable) {
        ThreadQueue threadQueue;
        RunnableWrapper wrapper = new RunnableWrapper();
        wrapper.threadQueue = threadQueue = AsyncServer.getOrCreateThreadQueue(handler.getLooper().getThread());
        wrapper.handler = handler;
        wrapper.runnable = runnable;
        threadQueue.add(wrapper);
        handler.post((Runnable)wrapper);
        threadQueue.queueSemaphore.release();
    }

    public static AsyncServer getDefault() {
        return mInstance;
    }

    public void setAutostart(boolean autoStart) {
        this.mAutoStart = autoStart;
    }

    public boolean getAutoStart() {
        return this.mAutoStart;
    }

    public boolean isRunning() {
        return this.mSelector != null;
    }

    private void handleSocket(AsyncNetworkSocket handler) throws ClosedChannelException {
        ChannelWrapper sc = handler.getChannel();
        SelectionKey ckey = sc.register(this.mSelector);
        ckey.attach(handler);
        handler.setup(this, ckey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllCallbacks(Object scheduled) {
        AsyncServer asyncServer = this;
        synchronized (asyncServer) {
            this.mQueue.remove(scheduled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object postDelayed(Runnable runnable, long delay) {
        Scheduled s;
        AsyncServer asyncServer = this;
        synchronized (asyncServer) {
            if (delay != 0L) {
                delay += System.currentTimeMillis();
            }
            s = new Scheduled(runnable, delay);
            this.mQueue.add(s);
            if (this.mSelector == null) {
                this.run(false, true);
            }
            if (Thread.currentThread() != this.mAffinity && this.mSelector != null) {
                this.mSelector.wakeup();
            }
        }
        return s;
    }

    public Object post(Runnable runnable) {
        return this.postDelayed(runnable, 0L);
    }

    public Object post(final CompletedCallback callback, final Exception e) {
        return this.post(new Runnable(){

            @Override
            public void run() {
                callback.onCompleted(e);
            }
        });
    }

    public void run(final Runnable runnable) {
        if (Thread.currentThread() == this.mAffinity) {
            this.post(runnable);
            AsyncServer.lockAndRunQueue(this, this.mQueue);
            return;
        }
        final Semaphore semaphore = new Semaphore(0);
        this.post(new Runnable(){

            @Override
            public void run() {
                runnable.run();
                semaphore.release();
            }
        });
        try {
            semaphore.acquire();
        }
        catch (InterruptedException e) {
            Log.e((String)LOGTAG, (String)"run", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        AsyncServer asyncServer = this;
        synchronized (asyncServer) {
            if (this.mSelector == null) {
                return;
            }
            final Selector currentSelector = this.mSelector;
            this.post(new Runnable(){

                @Override
                public void run() {
                    AsyncServer.shutdownEverything(currentSelector);
                }
            });
            Hashtable<Thread, AsyncServer> hashtable = mServers;
            synchronized (hashtable) {
                mServers.remove(this.mAffinity);
            }
            this.mQueue = new LinkedList();
            this.mSelector = null;
            this.mAffinity = null;
        }
    }

    protected void onDataTransmitted(int transmitted) {
    }

    public void listen(final InetAddress host, final int port, final ListenCallback handler) {
        this.run(new Runnable(){

            @Override
            public void run() {
                try {
                    final ServerSocketChannel server = ServerSocketChannel.open();
                    ServerSocketChannelWrapper wrapper = new ServerSocketChannelWrapper(server);
                    InetSocketAddress isa = host == null ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
                    server.socket().bind(isa);
                    final SelectionKey key = wrapper.register(AsyncServer.this.mSelector);
                    key.attach(handler);
                    handler.onListening(new AsyncServerSocket(){

                        @Override
                        public void stop() {
                            try {
                                server.close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            try {
                                key.cancel();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (Exception e) {
                    handler.onCompleted(e);
                }
            }
        });
    }

    private ConnectFuture connectResolvedInetSocketAddress(final InetSocketAddress address, final ConnectCallback callback) {
        final ConnectFuture cancel = new ConnectFuture();
        assert (!address.isUnresolved());
        this.post(new Runnable(){

            @Override
            public void run() {
                if (cancel.isCancelled()) {
                    return;
                }
                cancel.callback = callback;
                SelectionKey ckey = null;
                SocketChannel socket = null;
                try {
                    socket = cancel.socket = SocketChannel.open();
                    socket.configureBlocking(false);
                    ckey = socket.register(AsyncServer.this.mSelector, 8);
                    ckey.attach(cancel);
                    socket.connect(address);
                }
                catch (Exception e) {
                    if (ckey != null) {
                        ckey.cancel();
                    }
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    cancel.setComplete(e);
                }
            }
        });
        return cancel;
    }

    public Cancellable connectSocket(final InetSocketAddress remote, final ConnectCallback callback) {
        if (!remote.isUnresolved()) {
            return this.connectResolvedInetSocketAddress(remote, callback);
        }
        return new TransformFuture<AsyncSocket, InetAddress>(){

            @Override
            protected void transform(InetAddress result) throws Exception {
                this.setParent(AsyncServer.this.connectResolvedInetSocketAddress(new InetSocketAddress(remote.getHostName(), remote.getPort()), callback));
            }
        }.from(this.getByName(remote.getHostName()));
    }

    public Cancellable connectSocket(String host, int port, ConnectCallback callback) {
        return this.connectSocket(InetSocketAddress.createUnresolved(host, port), callback);
    }

    public Future<InetAddress[]> getAllByName(final String host) {
        final SimpleFuture<InetAddress[]> ret = new SimpleFuture<InetAddress[]>();
        this.synchronousWorkers.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    final InetAddress[] result = InetAddress.getAllByName(host);
                    if (result == null || result.length == 0) {
                        throw new Exception("no addresses for host");
                    }
                    AsyncServer.this.post(new Runnable(){

                        @Override
                        public void run() {
                            ret.setComplete(null, result);
                        }
                    });
                }
                catch (Exception e) {
                    AsyncServer.this.post(new Runnable(){

                        @Override
                        public void run() {
                            ret.setComplete(e, null);
                        }
                    });
                }
            }
        });
        return ret;
    }

    public Future<InetAddress> getByName(String host) {
        return new TransformFuture<InetAddress, InetAddress[]>(){

            @Override
            protected void transform(InetAddress[] result) throws Exception {
                this.setComplete(result[0]);
            }
        }.from(this.getAllByName(host));
    }

    public AsyncDatagramSocket connectDatagram(final String host, final int port) throws IOException {
        final DatagramChannel socket = DatagramChannel.open();
        final AsyncDatagramSocket handler = new AsyncDatagramSocket();
        handler.attach(socket);
        this.run(new Runnable(){

            @Override
            public void run() {
                try {
                    InetSocketAddress remote = new InetSocketAddress(host, port);
                    AsyncServer.this.handleSocket(handler);
                    socket.connect(remote);
                }
                catch (Exception e) {
                    Log.e((String)AsyncServer.LOGTAG, (String)"Datagram error", (Throwable)e);
                }
            }
        });
        return handler;
    }

    public AsyncDatagramSocket openDatagram() throws IOException {
        final DatagramChannel socket = DatagramChannel.open();
        final AsyncDatagramSocket handler = new AsyncDatagramSocket();
        handler.attach(socket);
        this.run(new Runnable(){

            @Override
            public void run() {
                try {
                    socket.socket().bind(null);
                    AsyncServer.this.handleSocket(handler);
                }
                catch (Exception e) {
                    Log.e((String)AsyncServer.LOGTAG, (String)"Datagram error", (Throwable)e);
                }
            }
        });
        return handler;
    }

    public AsyncDatagramSocket connectDatagram(final SocketAddress remote) throws IOException {
        final DatagramChannel socket = DatagramChannel.open();
        final AsyncDatagramSocket handler = new AsyncDatagramSocket();
        handler.attach(socket);
        this.run(new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncServer.this.handleSocket(handler);
                    socket.connect(remote);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addMe() {
        Hashtable<Thread, AsyncServer> hashtable = mServers;
        synchronized (hashtable) {
            AsyncServer current = mServers.get(Thread.currentThread());
            if (current != null) {
                return false;
            }
            mServers.put(this.mAffinity, this);
        }
        return true;
    }

    public static AsyncServer getCurrentThreadServer() {
        return mServers.get(Thread.currentThread());
    }

    public void run() {
        this.run(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(final boolean keepRunning, boolean newThread) {
        LinkedList<Scheduled> queue;
        Selector selector;
        boolean reentrant = false;
        AsyncServer asyncServer = this;
        synchronized (asyncServer) {
            if (this.mSelector != null) {
                Log.i((String)LOGTAG, (String)"Reentrant call");
                assert (Thread.currentThread() == this.mAffinity);
                reentrant = true;
                selector = this.mSelector;
                queue = this.mQueue;
            } else {
                try {
                    this.mSelector = SelectorProvider.provider().openSelector();
                    selector = this.mSelector;
                    queue = this.mQueue;
                }
                catch (IOException e) {
                    return;
                }
                this.mAffinity = newThread ? new Thread("AsyncServer"){

                    @Override
                    public void run() {
                        AsyncServer.run(AsyncServer.this, selector, queue, keepRunning);
                    }
                } : Thread.currentThread();
                if (!this.addMe()) {
                    try {
                        this.mSelector.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.mSelector = null;
                    this.mAffinity = null;
                    return;
                }
                if (newThread) {
                    this.mAffinity.start();
                    return;
                }
            }
        }
        if (reentrant) {
            try {
                AsyncServer.runLoop(this, selector, queue, false);
            }
            catch (Exception e) {
                Log.e((String)LOGTAG, (String)"exception?", (Throwable)e);
            }
            return;
        }
        AsyncServer.run(this, selector, queue, keepRunning);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void run(AsyncServer server, Selector selector, LinkedList<Scheduled> queue, boolean keepRunning) {
        Object object;
        while (true) {
            try {
                AsyncServer.runLoop(server, selector, queue, keepRunning);
            }
            catch (ClosedSelectorException e) {
            }
            catch (Exception e) {
                Log.e((String)LOGTAG, (String)"exception?", (Throwable)e);
            }
            object = server;
            synchronized (object) {
                if (!selector.isOpen() || selector.keys().size() <= 0 && !keepRunning && queue.size() <= 0) break;
            }
        }
        {
            AsyncServer.shutdownEverything(selector);
            if (server.mSelector == selector) {
                server.mQueue = new LinkedList();
                server.mSelector = null;
                server.mAffinity = null;
            }
        }
        object = mServers;
        synchronized (object) {
            mServers.remove(Thread.currentThread());
            return;
        }
    }

    private static void shutdownEverything(Selector selector) {
        try {
            for (SelectionKey key : selector.keys()) {
                try {
                    key.channel().close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    key.cancel();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            selector.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long lockAndRunQueue(AsyncServer server, LinkedList<Scheduled> queue) {
        long wait = Long.MAX_VALUE;
        while (true) {
            Scheduled run = null;
            AsyncServer asyncServer = server;
            synchronized (asyncServer) {
                long now = System.currentTimeMillis();
                LinkedList<Scheduled> later = null;
                while (queue.size() > 0) {
                    Scheduled s = queue.remove();
                    if (s.time <= now) {
                        run = s;
                        break;
                    }
                    wait = Math.min(wait, s.time - now);
                    if (later == null) {
                        later = new LinkedList<Scheduled>();
                    }
                    later.add(s);
                }
                if (later != null) {
                    queue.addAll(later);
                }
            }
            if (run == null) break;
            run.runnable.run();
        }
        return wait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runLoop(AsyncServer server, Selector selector, LinkedList<Scheduled> queue, boolean keepRunning) throws IOException {
        boolean needsSelect = true;
        long wait = AsyncServer.lockAndRunQueue(server, queue);
        AsyncServer asyncServer = server;
        synchronized (asyncServer) {
            int readyNow = selector.selectNow();
            if (readyNow == 0) {
                if (selector.keys().size() == 0 && !keepRunning && wait == Long.MAX_VALUE) {
                    return;
                }
            } else {
                needsSelect = false;
            }
        }
        if (needsSelect) {
            if (wait == Long.MAX_VALUE) {
                wait = 100L;
            }
            selector.select(wait);
        }
        Set<SelectionKey> readyKeys = selector.selectedKeys();
        for (SelectionKey key : readyKeys) {
            try {
                AsyncNetworkSocket handler;
                SocketChannel sc;
                if (key.isAcceptable()) {
                    ServerSocketChannel nextReady = (ServerSocketChannel)key.channel();
                    sc = nextReady.accept();
                    if (sc == null) continue;
                    sc.configureBlocking(false);
                    SelectionKey ckey = sc.register(selector, 1);
                    ListenCallback serverHandler = (ListenCallback)key.attachment();
                    AsyncNetworkSocket handler2 = new AsyncNetworkSocket();
                    handler2.attach(sc, (InetSocketAddress)sc.socket().getRemoteSocketAddress());
                    handler2.setup(server, ckey);
                    ckey.attach(handler2);
                    serverHandler.onAccepted(handler2);
                    continue;
                }
                if (key.isReadable()) {
                    handler = (AsyncNetworkSocket)key.attachment();
                    int transmitted = handler.onReadable();
                    server.onDataTransmitted(transmitted);
                    continue;
                }
                if (key.isWritable()) {
                    handler = (AsyncNetworkSocket)key.attachment();
                    handler.onDataWritable();
                    continue;
                }
                if (key.isConnectable()) {
                    ConnectFuture cancel = (ConnectFuture)key.attachment();
                    sc = (SocketChannel)key.channel();
                    key.interestOps(1);
                    try {
                        sc.finishConnect();
                        AsyncNetworkSocket newHandler = new AsyncNetworkSocket();
                        newHandler.setup(server, key);
                        newHandler.attach(sc, (InetSocketAddress)sc.socket().getRemoteSocketAddress());
                        key.attach(newHandler);
                        if (!cancel.setComplete(newHandler)) continue;
                        cancel.callback.onConnectCompleted(null, newHandler);
                    }
                    catch (Exception ex) {
                        key.cancel();
                        sc.close();
                        if (!cancel.setComplete(ex)) continue;
                        cancel.callback.onConnectCompleted(ex, null);
                    }
                    continue;
                }
                Log.i((String)LOGTAG, (String)"wtf");
                assert (false);
            }
            catch (Exception ex) {
                Log.e((String)LOGTAG, (String)"inner loop exception", (Throwable)ex);
            }
        }
        readyKeys.clear();
    }

    public void dump() {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (AsyncServer.this.mSelector == null) {
                    Log.i((String)AsyncServer.LOGTAG, (String)"Server dump not possible. No selector?");
                    return;
                }
                Log.i((String)AsyncServer.LOGTAG, (String)("Key Count: " + AsyncServer.this.mSelector.keys().size()));
                for (SelectionKey key : AsyncServer.this.mSelector.keys()) {
                    Log.i((String)AsyncServer.LOGTAG, (String)("Key: " + key));
                }
            }
        });
    }

    public Thread getAffinity() {
        return this.mAffinity;
    }

    public boolean isAffinityThread() {
        return this.mAffinity == Thread.currentThread();
    }

    static {
        try {
            if (Build.VERSION.SDK_INT <= 8) {
                System.setProperty("java.net.preferIPv4Stack", "true");
                System.setProperty("java.net.preferIPv6Addresses", "false");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        mInstance = new AsyncServer(){
            {
                this.setAutostart(true);
            }
        };
        mServers = new Hashtable();
    }

    private class ConnectFuture
    extends SimpleFuture<AsyncNetworkSocket> {
        SocketChannel socket;
        ConnectCallback callback;

        private ConnectFuture() {
        }

        @Override
        protected void cancelCleanup() {
            super.cancelCleanup();
            AsyncServer.this.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (ConnectFuture.this.socket != null) {
                            ConnectFuture.this.socket.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private static class Scheduled {
        public Runnable runnable;
        public long time;

        public Scheduled(Runnable runnable, long time) {
            this.runnable = runnable;
            this.time = time;
        }
    }

    private static class RunnableWrapper
    implements Runnable {
        boolean hasRun;
        Runnable runnable;
        ThreadQueue threadQueue;
        Handler handler;

        private RunnableWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RunnableWrapper runnableWrapper = this;
            synchronized (runnableWrapper) {
                if (this.hasRun) {
                    return;
                }
                this.hasRun = true;
            }
            try {
                this.runnable.run();
            }
            finally {
                this.threadQueue.remove(this);
                this.handler.removeCallbacks((Runnable)this);
                this.threadQueue = null;
                this.handler = null;
                this.runnable = null;
            }
        }
    }

    public static class ThreadQueue
    extends LinkedList<Runnable> {
        AsyncSemaphore waiter;
        Semaphore queueSemaphore = new Semaphore(0);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(Runnable object) {
            ThreadQueue threadQueue = this;
            synchronized (threadQueue) {
                return super.add(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object object) {
            ThreadQueue threadQueue = this;
            synchronized (threadQueue) {
                return super.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Runnable remove() {
            ThreadQueue threadQueue = this;
            synchronized (threadQueue) {
                if (this.isEmpty()) {
                    return null;
                }
                return (Runnable)super.remove();
            }
        }
    }

    public static class AsyncSemaphore {
        Semaphore semaphore = new Semaphore(0);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() throws InterruptedException {
            ThreadQueue threadQueue = AsyncServer.getOrCreateThreadQueue(Thread.currentThread());
            AsyncSemaphore last = threadQueue.waiter;
            threadQueue.waiter = this;
            Semaphore queueSemaphore = threadQueue.queueSemaphore;
            try {
                if (this.semaphore.tryAcquire()) {
                    return;
                }
                while (true) {
                    Runnable run;
                    if ((run = threadQueue.remove()) != null) {
                        run.run();
                        continue;
                    }
                    int permits = Math.max(1, queueSemaphore.availablePermits());
                    queueSemaphore.acquire(permits);
                    if (this.semaphore.tryAcquire()) break;
                }
            }
            finally {
                threadQueue.waiter = last;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryAcquire(long timeout, TimeUnit timeunit) throws InterruptedException {
            long timeoutMs = TimeUnit.MILLISECONDS.convert(timeout, timeunit);
            ThreadQueue threadQueue = AsyncServer.getOrCreateThreadQueue(Thread.currentThread());
            AsyncSemaphore last = threadQueue.waiter;
            threadQueue.waiter = this;
            Semaphore queueSemaphore = threadQueue.queueSemaphore;
            try {
                if (this.semaphore.tryAcquire()) {
                    boolean bl = true;
                    return bl;
                }
                long start = System.currentTimeMillis();
                while (true) {
                    Runnable run;
                    if ((run = threadQueue.remove()) != null) {
                        run.run();
                        continue;
                    }
                    int permits = Math.max(1, queueSemaphore.availablePermits());
                    if (!queueSemaphore.tryAcquire(permits, timeoutMs, TimeUnit.MILLISECONDS)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (this.semaphore.tryAcquire()) {
                        boolean bl = true;
                        return bl;
                    }
                    if (System.currentTimeMillis() - start >= timeoutMs) break;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                threadQueue.waiter = last;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            this.semaphore.release();
            WeakHashMap weakHashMap = mThreadQueues;
            synchronized (weakHashMap) {
                for (ThreadQueue threadQueue : mThreadQueues.values()) {
                    if (threadQueue.waiter != this) continue;
                    threadQueue.queueSemaphore.release();
                }
            }
        }
    }
}

