/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.DataCallback;
import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FileDataEmitter
implements DataEmitter {
    AsyncServer server;
    File file;
    DataCallback callback;
    boolean paused;
    ByteBufferList pending = new ByteBufferList();
    FileChannel channel;
    Runnable pumper = new Runnable(){

        @Override
        public void run() {
            try {
                if (FileDataEmitter.this.channel == null) {
                    FileDataEmitter.this.channel = new FileInputStream(FileDataEmitter.this.file).getChannel();
                }
                if (!FileDataEmitter.this.pending.isEmpty()) {
                    Util.emitAllData((DataEmitter)FileDataEmitter.this, FileDataEmitter.this.pending);
                    if (!FileDataEmitter.this.pending.isEmpty()) {
                        return;
                    }
                }
                do {
                    ByteBuffer b;
                    if (-1 == FileDataEmitter.this.channel.read(b = ByteBuffer.allocate(8192))) {
                        FileDataEmitter.this.report(null);
                        return;
                    }
                    b.flip();
                    FileDataEmitter.this.pending.add(b);
                    Util.emitAllData((DataEmitter)FileDataEmitter.this, FileDataEmitter.this.pending);
                } while (FileDataEmitter.this.pending.remaining() == 0 && !FileDataEmitter.this.isPaused());
            }
            catch (Exception e) {
                FileDataEmitter.this.report(e);
            }
        }
    };
    CompletedCallback endCallback;

    public FileDataEmitter(AsyncServer server, File file) {
        this.server = server;
        this.file = file;
        boolean bl = this.paused = !server.isAffinityThread();
        if (!this.paused) {
            this.doResume();
        }
    }

    @Override
    public void setDataCallback(DataCallback callback) {
        this.callback = callback;
    }

    @Override
    public DataCallback getDataCallback() {
        return this.callback;
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public void pause() {
        this.paused = true;
    }

    @Override
    public void resume() {
        this.paused = false;
        this.doResume();
    }

    private void report(Exception e) {
        try {
            this.channel.close();
        }
        catch (Exception ex) {
            e = ex;
        }
        this.callback = null;
        if (this.endCallback != null) {
            this.endCallback.onCompleted(e);
            this.endCallback = null;
        }
    }

    private void doResume() {
        this.server.post(this.pumper);
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void setEndCallback(CompletedCallback callback) {
        this.endCallback = callback;
    }

    @Override
    public CompletedCallback getEndCallback() {
        return this.endCallback;
    }

    @Override
    public AsyncServer getServer() {
        return this.server;
    }

    @Override
    public void close() {
        try {
            this.channel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

