/*
 * Decompiled with CFR 0.152.
 */
package com.koubei.cavalry.architect.support;

import com.koubei.cavalry.architect.support.SavedRequest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class AlipayAuthFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(AlipayAuthFilter.class);
    @Value(value="${alipay.authUrl}")
    private String alipayAuthUrl;
    @Value(value="${alipay.appId}")
    private String appId;
    @Value(value="${alipay.domain}")
    private String domain;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        if (httpServletRequest.getSession().getAttribute("userInfo") == null) {
            SavedRequest savedRequest = new SavedRequest();
            savedRequest.setParameterMap(new HashMap<String, String[]>(httpServletRequest.getParameterMap()));
            savedRequest.setServletPath(httpServletRequest.getServletPath());
            httpServletRequest.getSession().setAttribute("savedRequest", (Object)savedRequest);
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            httpServletResponse.sendRedirect(this.buildAuthRedirect());
        } else {
            chain.doFilter(request, response);
        }
    }

    private String buildAuthRedirect() {
        try {
            String redirectUrl = URLEncoder.encode(this.domain + "/alipay/authcallback", "UTF-8");
            return this.alipayAuthUrl + "?app_id=" + this.appId + "&scope=auth_user&redirect_uri=" + redirectUrl;
        }
        catch (UnsupportedEncodingException ext) {
            logger.error("format redirect url error!!!", (Throwable)ext);
            throw new RuntimeException(ext);
        }
    }

    public void destroy() {
    }
}

