/*
 * Decompiled with CFR 0.152.
 */
package com.koubei.cavalry.architect.log.rds;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.stat.JdbcSqlStatValue;
import com.koubei.cavalry.architect.log.AbstractCavalryLogger;
import com.koubei.cavalry.architect.log.rds.RdsLog;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.stereotype.Component;

@Component
public class RdsLogger
extends AbstractCavalryLogger<RdsLog> {
    @Override
    public RdsLog getLog() {
        RdsLog log = new RdsLog();
        try {
            long dalCount = 0L;
            long dalTimeConsumed = 0L;
            DruidDataSource ds = (DruidDataSource)this.context.getBean(DruidDataSource.class);
            List sqlList = ds.getStatValueAndReset().getSqlList();
            for (JdbcSqlStatValue sqlStatValue : sqlList) {
                long count = sqlStatValue.getExecuteCount();
                long millis = sqlStatValue.getExecuteMillisTotal();
                dalCount += count;
                dalTimeConsumed += millis;
                log.addSqlExecInfo(sqlStatValue.getSql(), count, millis);
            }
            log.setDalCount(dalCount);
            log.setDalTimeAvg((double)dalTimeConsumed / (double)dalCount);
        }
        catch (BeansException beansException) {
            // empty catch block
        }
        return log;
    }
}

