/*
 * Decompiled with CFR 0.152.
 */
package com.koubei.cavalry.architect.log.pv;

import com.koubei.cavalry.architect.console.SimpleResponse;
import com.koubei.cavalry.architect.log.pv.PvInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Configuration
@EnableAspectJAutoProxy
@Aspect
public class ControllerAspect {
    private final ConcurrentHashMap<String, PvInfo> urlPvMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, List<ExceptionHolder>> urlErrorMap = new ConcurrentHashMap();

    @Pointcut(value="@annotation(requestMapping)")
    public void execPointcut(RequestMapping requestMapping) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execPointcut(requestMapping)", argNames="pjp,requestMapping")
    public Object aspect(ProceedingJoinPoint pjp, RequestMapping requestMapping) throws Throwable {
        String subPath;
        if (requestMapping.value().length > 0) {
            subPath = requestMapping.value()[0];
        } else if (requestMapping.path().length > 0) {
            subPath = requestMapping.path()[0];
        } else {
            return pjp.proceed();
        }
        Class<?> controllerClass = pjp.getTarget().getClass();
        RequestMapping annotation = controllerClass.getAnnotation(RequestMapping.class);
        if (annotation != null) {
            if (annotation.value().length > 0) {
                subPath = annotation.value()[0] + subPath;
            } else if (annotation.path().length > 0) {
                subPath = annotation.path()[0] + subPath;
            }
        }
        if (!subPath.equals("/c/v")) {
            this.record(subPath);
            long start = System.currentTimeMillis();
            try {
                Object object = this.proceed(pjp, subPath);
                return object;
            }
            finally {
                long elapsed = System.currentTimeMillis() - start;
                this.urlPvMap.putIfAbsent(subPath, new PvInfo());
                this.urlPvMap.get(subPath).getTime().addAndGet(elapsed);
            }
        }
        return this.proceed(pjp, subPath);
    }

    private Object proceed(ProceedingJoinPoint joinPoint, String path) throws Throwable {
        try {
            return joinPoint.proceed();
        }
        catch (Exception e) {
            this.urlErrorMap.putIfAbsent(path, Collections.synchronizedList(new ArrayList()));
            this.urlErrorMap.get(path).add(new ExceptionHolder(e));
            Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
            if ((method.getAnnotation(ResponseBody.class) != null || joinPoint.getTarget().getClass().getAnnotation(RestController.class) != null) && method.getReturnType().equals(SimpleResponse.class)) {
                return SimpleResponse.fail("");
            }
            Class<?> returnType = method.getReturnType();
            if (returnType.equals(SimpleResponse.class)) {
                // empty if block
            }
            return null;
        }
    }

    public Map<String, PvInfo> getStatAndReset() {
        HashMap<String, PvInfo> pvMap = new HashMap<String, PvInfo>(this.urlPvMap);
        this.urlPvMap.clear();
        return pvMap;
    }

    public void record(String path) {
        this.urlPvMap.putIfAbsent(path, new PvInfo());
        this.urlPvMap.get(path).getCount().incrementAndGet();
    }

    private static class ExceptionHolder {
        private Exception exception;
        private long timestamp;

        ExceptionHolder(Exception e) {
            this.exception = e;
            this.timestamp = System.currentTimeMillis();
        }

        public Exception getException() {
            return this.exception;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

