/*
 * Decompiled with CFR 0.152.
 */
package com.koubei.cavalry.architect.log.oss;

import com.aliyun.oss.OSSClient;
import com.koubei.cavalry.architect.log.AbstractCavalryLogger;
import com.koubei.cavalry.architect.log.oss.OssAspect;
import com.koubei.cavalry.architect.log.oss.OssExecStat;
import com.koubei.cavalry.architect.log.oss.OssLog;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OssLogger
extends AbstractCavalryLogger<OssLog> {
    private OssAspect ossAspect;

    @Override
    public OssLog getLog() {
        OssLog log = new OssLog();
        try {
            OSSClient ossClient = (OSSClient)this.context.getBean(OSSClient.class);
            long execCount = 0L;
            long execTimeConsume = 0L;
            Map<String, OssExecStat> statMap = this.ossAspect.getStatAndReset();
            for (Map.Entry<String, OssExecStat> entry : statMap.entrySet()) {
                OssExecStat ossExecStat = entry.getValue();
                execCount += ossExecStat.getExecCount();
                execTimeConsume += ossExecStat.getExecTimeMillisTotal();
            }
            log.setOssCount(execCount);
            log.setOssTimeAvg((double)execTimeConsume / (double)execCount);
            log.setOssExecInfos(statMap);
        }
        catch (BeansException beansException) {
            // empty catch block
        }
        return log;
    }

    @Autowired
    public void setOssAspect(OssAspect ossAspect) {
        this.ossAspect = ossAspect;
    }
}

