/*
 * Decompiled with CFR 0.152.
 */
package com.koubei.cavalry.architect.log.oss;

import com.koubei.cavalry.architect.log.oss.OssExecStat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@Configuration
@EnableAspectJAutoProxy
@Aspect
public class OssAspect {
    private ConcurrentHashMap<String, OssExecStat> execStatMap = new ConcurrentHashMap();

    @Pointcut(value="execution(* com.aliyun.oss.OSS.*(..))")
    public void execPointcut() {
    }

    @Around(value="execPointcut()")
    public Object aspect(ProceedingJoinPoint pjp) throws Throwable {
        String method = pjp.getSignature().toString();
        this.execStatMap.putIfAbsent(method, new OssExecStat());
        OssExecStat execStat = this.execStatMap.get(method);
        execStat.increaseCount();
        try {
            long current = this.getCurMillis();
            Object ret = pjp.proceed();
            long execTime = this.getCurMillis() - current;
            execStat.increaseTime(execTime);
            return ret;
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                execStat.increaseErr(throwable);
            }
            throw throwable;
        }
    }

    private long getCurMillis() {
        return System.currentTimeMillis();
    }

    public Map<String, OssExecStat> getStatAndReset() {
        HashMap<String, OssExecStat> statMap = new HashMap<String, OssExecStat>(this.execStatMap);
        this.execStatMap.clear();
        return statMap;
    }
}

