/*
 * Decompiled with CFR 0.152.
 */
package com.koubei.cavalry.architect.log.healthcheck;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.codahale.metrics.health.HealthCheck;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OssHealthCheck
extends HealthCheck {
    private OSS oss;
    private static final String TEST_FILE_NAME = "testFile";

    protected HealthCheck.Result check() throws Exception {
        String bucket = UUID.randomUUID().toString().replace("-", "");
        try {
            boolean exist = this.oss.doesBucketExist(bucket);
            if (!exist) {
                this.oss.createBucket(bucket);
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[]{104, 101, 108, 108, 111});
            this.oss.putObject(bucket, TEST_FILE_NAME, (InputStream)inputStream);
            this.oss.deleteObject(bucket, TEST_FILE_NAME);
            this.oss.deleteBucket(bucket);
            return HealthCheck.Result.healthy();
        }
        catch (OSSException e) {
            return HealthCheck.Result.unhealthy((Throwable)e);
        }
    }

    @Autowired
    public void setDataSource(OSS oss) {
        this.oss = oss;
    }
}

