/*
 * Decompiled with CFR 0.152.
 */
package com.koubei.cavalry.architect.log.healthcheck;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.koubei.cavalry.architect.ConfigHolder;
import com.koubei.cavalry.architect.log.AbstractCavalryLogger;
import com.koubei.cavalry.architect.log.healthcheck.OssHealthCheck;
import com.koubei.cavalry.architect.log.healthcheck.RdsHealthCheck;
import com.koubei.cavalry.architect.log.healthcheck.ResourceHealth;
import com.koubei.cavalry.architect.log.healthcheck.ResourceHealthLog;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HealthCheckLogger
extends AbstractCavalryLogger<ResourceHealthLog> {
    private HealthCheckRegistry healthCheckRegistry;
    private ConfigHolder configHolder;
    @Autowired
    private RdsHealthCheck rdsHealthCheck;
    @Autowired
    private OssHealthCheck ossHealthCheck;

    @PostConstruct
    public void initHealCheck() {
        if (this.configHolder.isDsAvailable()) {
            this.healthCheckRegistry.register("rds", (HealthCheck)this.rdsHealthCheck);
        }
        if (this.configHolder.isOssAvailable()) {
            this.healthCheckRegistry.register("oss", (HealthCheck)this.ossHealthCheck);
        }
    }

    @Autowired
    public void setHealthCheckRegistry(HealthCheckRegistry healthCheckRegistry) {
        this.healthCheckRegistry = healthCheckRegistry;
    }

    @Autowired
    public void setConfigHolder(ConfigHolder configHolder) {
        this.configHolder = configHolder;
    }

    @Override
    protected ResourceHealthLog getLog() {
        SortedMap results = this.healthCheckRegistry.runHealthChecks();
        HashMap<String, ResourceHealth> map = new HashMap<String, ResourceHealth>();
        for (Map.Entry entry : results.entrySet()) {
            HealthCheck.Result result = (HealthCheck.Result)entry.getValue();
            ResourceHealth health = new ResourceHealth();
            String name = (String)entry.getKey();
            health.setName(name);
            health.setHealthy(result.isHealthy());
            health.setMessage(result.getError() != null ? result.getError().toString() : null);
            map.put(name, health);
        }
        ResourceHealthLog log = new ResourceHealthLog();
        log.setResourceHealth(map);
        return log;
    }
}

