/*
 * Decompiled with CFR 0.152.
 */
package com.koubei.cavalry.architect.log.hardware;

import com.koubei.cavalry.architect.log.AbstractCavalryLogger;
import com.koubei.cavalry.architect.log.hardware.DiskInfo;
import com.koubei.cavalry.architect.log.hardware.NetworkInfo;
import com.koubei.cavalry.architect.log.hardware.SystemInfoLog;
import java.io.File;
import java.util.HashMap;
import org.springframework.stereotype.Component;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;

@Component
public class SystemInfoLogger
extends AbstractCavalryLogger<SystemInfoLog> {
    private static final int step = 2;
    private static SystemInfo oshiSystemInfo;
    private static HardwareAbstractionLayer hardware;
    private static GlobalMemory globalMemory;
    private static CentralProcessor centralProcessor;
    private static NetworkIF[] networkIFs;

    @Override
    public SystemInfoLog getLog() {
        SystemInfoLog systemInfoLog = new SystemInfoLog();
        HWDiskStore[] diskStores = hardware.getDiskStores();
        HashMap<String, DiskTempInfo> diskTempInfoMap = new HashMap<String, DiskTempInfo>();
        for (HWDiskStore diskStore : diskStores) {
            DiskTempInfo diskTempInfo = new DiskTempInfo();
            diskTempInfo.bytesWrite = diskStore.getWriteBytes();
            diskTempInfo.bytesRead = diskStore.getReadBytes();
            diskTempInfoMap.put(diskStore.getName(), diskTempInfo);
        }
        HashMap<String, NetTempInfo> netTempInfoMap = new HashMap<String, NetTempInfo>();
        for (NetworkIF networkIF : networkIFs) {
            networkIF.updateNetworkStats();
            NetTempInfo netTempInfo = new NetTempInfo();
            netTempInfo.bytesSent = networkIF.getBytesSent();
            netTempInfo.bytesRecv = networkIF.getBytesRecv();
            netTempInfoMap.put(networkIF.getName(), netTempInfo);
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            return null;
        }
        HWDiskStore[] diskStores_ = hardware.getDiskStores();
        DiskInfo[] diskInfos = new DiskInfo[diskStores_.length];
        for (int i = 0; i < diskStores_.length; ++i) {
            HWDiskStore disk = diskStores_[i];
            long size = disk.getSize();
            String name = disk.getName();
            DiskTempInfo diskTempInfo = (DiskTempInfo)diskTempInfoMap.get(name);
            DiskInfo diskInfo = new DiskInfo();
            long writeBytes = disk.getWriteBytes();
            diskInfo.setName(name);
            if (writeBytes != 0L) {
                File file = File.listRoots()[0];
                long totalSpace = file.getTotalSpace();
                diskInfo.setSize(totalSpace);
                diskInfo.setUsage((double)(totalSpace - file.getUsableSpace()) / (double)totalSpace);
            }
            diskInfo.setBytesReadPerSec((long)((double)(disk.getReadBytes() - diskTempInfo.bytesRead) / 2.0));
            diskInfo.setBytesWritePerSec((long)((double)(writeBytes - diskTempInfo.bytesWrite) / 2.0));
            diskInfos[i] = diskInfo;
        }
        systemInfoLog.setDiskInfos(diskInfos);
        NetworkInfo[] networkInfos = new NetworkInfo[networkIFs.length];
        for (int i = 0; i < networkIFs.length; ++i) {
            NetworkIF networkIF = networkIFs[i];
            networkIF.updateNetworkStats();
            String name = networkIF.getName();
            NetTempInfo netTempInfo = (NetTempInfo)netTempInfoMap.get(name);
            NetworkInfo networkInfo = new NetworkInfo();
            networkInfo.setName(name);
            networkInfo.setBytesSentPerSec((long)((double)(networkIF.getBytesSent() - netTempInfo.bytesSent) / 2.0));
            networkInfo.setBytesRecvPerSec((long)((double)(networkIF.getBytesRecv() - netTempInfo.bytesRecv) / 2.0));
            networkInfos[i] = networkInfo;
        }
        systemInfoLog.setNetworkInfos(networkInfos);
        double[] loadAvg = centralProcessor.getSystemLoadAverage(3);
        systemInfoLog.setLoad_1(loadAvg[0]);
        systemInfoLog.setLoad_5(loadAvg[1]);
        systemInfoLog.setLoad_15(loadAvg[2]);
        long totalMem = globalMemory.getTotal();
        systemInfoLog.setMemoryTotal(totalMem);
        systemInfoLog.setMemoryUsage((double)(totalMem - globalMemory.getAvailable()) / (double)totalMem);
        return systemInfoLog;
    }

    static {
        try {
            oshiSystemInfo = new SystemInfo();
            hardware = oshiSystemInfo.getHardware();
            globalMemory = hardware.getMemory();
            centralProcessor = hardware.getProcessor();
            networkIFs = hardware.getNetworkIFs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class NetTempInfo {
        private long bytesSent;
        private long bytesRecv;

        private NetTempInfo() {
        }
    }

    private static class DiskTempInfo {
        private long bytesWrite;
        private long bytesRead;

        private DiskTempInfo() {
        }
    }
}

