/*
 * Decompiled with CFR 0.152.
 */
package com.koubei.cavalry.architect.csys;

import com.koubei.cavalry.architect.csys.entry.AlipayUser;
import com.koubei.cavalry.architect.csys.service.AlipayUserService;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class AlipayUserServiceImpl
implements AlipayUserService {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public int insert(AlipayUser alipayUser) {
        return this.jdbcTemplate.update("INSERT INTO kb_user (user_id,name,avatar,access_token,gmt_token_expire,gmt_create) VALUES (?,?,?,?,?,?)", new Object[]{alipayUser.getUserId(), alipayUser.getName(), alipayUser.getAvatar(), alipayUser.getAccessToken(), alipayUser.getGmtTokenExpire(), alipayUser.getGmtCreate()});
    }

    @Override
    public int updateByUserId(AlipayUser alipayUser) {
        StringBuilder sqlBuilder = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        sqlBuilder.append("update kb_user set gmt_modified = ?");
        params.add(new Timestamp(System.currentTimeMillis()));
        if (alipayUser.getName() != null) {
            sqlBuilder.append(", name = ?");
            params.add(alipayUser.getName());
        }
        if (alipayUser.getAvatar() != null) {
            sqlBuilder.append(", avatar = ?");
            params.add(alipayUser.getAvatar());
        }
        if (alipayUser.getAccessToken() != null) {
            sqlBuilder.append(", access_token = ? ");
            params.add(alipayUser.getAccessToken());
        }
        if (alipayUser.getGmtTokenExpire() != null) {
            sqlBuilder.append(", gmt_token_expire = ? ");
            params.add(alipayUser.getGmtTokenExpire());
        }
        sqlBuilder.append("where user_id = ?");
        params.add(alipayUser.getUserId());
        return this.jdbcTemplate.update(sqlBuilder.toString(), params.toArray());
    }

    @Override
    public AlipayUser loadByUserId(final String userId) {
        try {
            return (AlipayUser)this.jdbcTemplate.queryForObject("SELECT * FROM kb_user WHERE user_id = ?", (RowMapper)new RowMapper<AlipayUser>(){

                public AlipayUser mapRow(ResultSet rs, int rowNum) throws SQLException {
                    AlipayUser alipayUser = new AlipayUser();
                    alipayUser.setId(rs.getLong("id"));
                    alipayUser.setUserId(userId);
                    alipayUser.setName(rs.getString("name"));
                    alipayUser.setAvatar(rs.getString("avatar"));
                    alipayUser.setAccessToken(rs.getString("access_token"));
                    alipayUser.setGmtTokenExpire(rs.getTimestamp("gmt_token_expire"));
                    alipayUser.setGmtCreate(rs.getTimestamp("gmt_create"));
                    alipayUser.setGmtModify(rs.getTimestamp("gmt_modified"));
                    return alipayUser;
                }
            }, new Object[]{userId});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public boolean doesUserExists(String userId) {
        return this.loadByUserId(userId) != null;
    }
}

