/*
 * Decompiled with CFR 0.152.
 */
package com.koubei.cavalry.architect.console;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.koubei.cavalry.architect.console.SimpleResponse;
import com.koubei.cavalry.architect.support.SortedProperties;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import javax.servlet.http.HttpServletRequest;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.auth.PlainCallbackHandler;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/config"})
public class ResourceController {
    private String propLocation = System.getProperty("user.dir") + "/web/src/main/resources/config/application-resource-user-config.properties";
    private boolean inDev = true;
    private static final String TEST_BUCKET_NAME = "cavalry-execPointcut-bucket";
    @Value(value="${rds.host}")
    private String rdsHost;
    @Value(value="${rds.dbName}")
    private String rdsDbName;
    @Value(value="${rds.username}")
    private String rdsUsername;
    @Value(value="${rds.password}")
    private String rdsPassword;
    @Value(value="${oss.endpoint}")
    private String ossEndpoint;
    @Value(value="${oss.accessKeyId}")
    private String ossAccessKeyId;
    @Value(value="${oss.accessKeySecret}")
    private String ossAccessKeySecret;
    @Value(value="${ocs.username}")
    private String ocsUsername;
    @Value(value="${ocs.port}")
    private String ocsPort;
    @Value(value="${ocs.host}")
    private String ocsHost;
    @Value(value="${ocs.password}")
    private String ocsPassword;
    @Value(value="${alipay.appId}")
    private String appId;
    @Value(value="${alipay.privateKey}")
    private String privateKey;
    @Value(value="${alipay.alipayPublicKey}")
    private String alipayPublicKey;
    @Value(value="${alipay.domain}")
    private String domain;

    public ResourceController() {
        try {
            FileInputStream stream = new FileInputStream(this.propLocation);
            stream.close();
        }
        catch (IOException e) {
            this.inDev = false;
        }
    }

    @RequestMapping(value={"/set"})
    public SimpleResponse set(@RequestParam String data) {
        try {
            JSONObject object = JSON.parseObject((String)data);
            FileInputStream inputStream = new FileInputStream(this.propLocation);
            SortedProperties properties = new SortedProperties();
            properties.load(inputStream);
            inputStream.close();
            String configType = object.getString("configType");
            JSONObject config = object.getJSONObject("configData");
            for (Map.Entry entry : config.entrySet()) {
                ((Properties)properties).put(String.format("%s.%s", configType, entry.getKey()), entry.getValue());
            }
            FileOutputStream outputStream = new FileOutputStream(this.propLocation);
            properties.store(outputStream, null);
            outputStream.close();
            return SimpleResponse.success(null);
        }
        catch (Exception e) {
            return SimpleResponse.fail(e.toString());
        }
    }

    @RequestMapping(value={"/load"})
    public Object loadConfig(HttpServletRequest request) {
        PropLoadResult propLoadResult = new PropLoadResult();
        JSONObject result = new JSONObject();
        propLoadResult.result = result;
        propLoadResult.dev = this.inDev;
        if (this.inDev) {
            try {
                FileInputStream inputStream = new FileInputStream(this.propLocation);
                SortedProperties properties = new SortedProperties();
                properties.load(inputStream);
                inputStream.close();
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String[] split = ((String)entry.getKey()).split("[.]");
                    String type = split[0];
                    String prop = split[1];
                    if (!result.containsKey((Object)type)) {
                        result.put(type, (Object)new JSONObject());
                    }
                    ((JSONObject)result.get((Object)type)).put(prop, entry.getValue());
                }
                return SimpleResponse.success(propLoadResult);
            }
            catch (Exception e) {
                return SimpleResponse.fail(e.toString());
            }
        }
        JSONObject rds = new JSONObject();
        rds.put("host", (Object)this.rdsHost);
        rds.put("dbName", (Object)this.rdsDbName);
        rds.put("username", (Object)this.rdsUsername);
        rds.put("password", (Object)this.rdsPassword);
        result.put("rds", (Object)rds);
        JSONObject ocs = new JSONObject();
        ocs.put("host", (Object)this.ocsHost);
        ocs.put("port", (Object)this.ocsPort);
        ocs.put("username", (Object)this.ocsUsername);
        ocs.put("password", (Object)this.ocsPassword);
        result.put("ocs", (Object)ocs);
        JSONObject oss = new JSONObject();
        oss.put("endpoint", (Object)this.ossEndpoint);
        oss.put("accessKeyId", (Object)this.ossAccessKeyId);
        oss.put("accessKeySecret", (Object)this.ossAccessKeySecret);
        result.put("ocs", (Object)oss);
        JSONObject alipay = new JSONObject();
        alipay.put("appId", (Object)this.appId);
        alipay.put("privateKey", (Object)this.privateKey);
        alipay.put("alipayPublicKey", (Object)this.alipayPublicKey);
        alipay.put("domain", (Object)this.domain);
        result.put("alipay", (Object)alipay);
        return SimpleResponse.success(propLoadResult);
    }

    @RequestMapping(value={"/test"})
    public SimpleResponse testConnection(@RequestParam String data) {
        JSONObject param = JSON.parseObject((String)data);
        String configType = param.getString("configType");
        JSONObject config = param.getJSONObject("configData");
        switch (configType) {
            case "rds": {
                if (this.testRds(config.getString("host"), config.getString("dbName"), config.getString("username"), config.getString("password"))) {
                    return SimpleResponse.success();
                }
                return SimpleResponse.fail(null);
            }
            case "oss": {
                if (this.testOss(config.getString("endpoint"), config.getString("accessKeyId"), config.getString("accessKeySecret"))) {
                    return SimpleResponse.success();
                }
                return SimpleResponse.fail(null);
            }
            case "ocs": {
                if (this.testMemcache(config.getString("endpoint"), config.getString("accessKeyId"), config.getString("accessKeySecret"))) {
                    return SimpleResponse.success();
                }
                return SimpleResponse.fail(null);
            }
        }
        return SimpleResponse.success();
    }

    private boolean testRds(String host, String dbName, String username, String password) {
        try {
            Class.forName("com.mysql.jdbc.Driver");
            DriverManager.getConnection(String.format("jdbc:mysql://%s/%s", host, dbName), username, password);
            return true;
        }
        catch (ClassNotFoundException | SQLException e) {
            return false;
        }
    }

    private boolean testOss(String endpoint, String id, String secrete) {
        try {
            OSSClient client = new OSSClient(endpoint, id, secrete);
            boolean exist = client.doesBucketExist(TEST_BUCKET_NAME);
            if (!exist) {
                client.createBucket(TEST_BUCKET_NAME);
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[]{104, 101, 108, 108, 48});
            client.putObject(TEST_BUCKET_NAME, "testFile", (InputStream)inputStream);
            client.deleteObject(TEST_BUCKET_NAME, "testFile");
            client.deleteBucket(TEST_BUCKET_NAME);
        }
        catch (OSSException e) {
            return false;
        }
        return true;
    }

    private boolean testMemcache(String domain, String username, String password) {
        System.exit(0);
        return true;
    }

    public static void main(String[] args) throws IOException {
        MemcachedClient client = new MemcachedClient(new ConnectionFactoryBuilder().setProtocol(ConnectionFactoryBuilder.Protocol.BINARY).setAuthDescriptor(new AuthDescriptor(new String[]{"PLAIN"}, (CallbackHandler)new PlainCallbackHandler("84194f630aec417d", "Aqcpaas123456"))).build(), AddrUtil.getAddresses((String)"84194f630aec417d.m.cnhzaliem21pub001.ocs.aliyuncs.com:11211"));
        client.add("execPointcut", 3600, (Object)"i am cache obj");
        System.out.println(client.get("execPointcut"));
    }

    private static class PropLoadResult {
        private JSONObject result;
        private boolean dev;

        private PropLoadResult() {
        }

        public JSONObject getResult() {
            return this.result;
        }

        public boolean isDev() {
            return this.dev;
        }
    }
}

