/*
 * Decompiled with CFR 0.152.
 */
package com.koubei.cavalry.architect.console;

import com.koubei.cavalry.architect.csys.entry.AlipayUser;
import com.koubei.cavalry.architect.csys.service.AlipayUserService;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class AbstractAlipayController {
    @Value(value="${alipay.appId}")
    private String appId;
    @Value(value="${alipay.authUrl}")
    private String alipayAuthUrl;
    @Value(value="${alipay.redirectUrl}")
    private String redirectUrl;
    private AlipayUserService alipayUserService;
    private final String LOGIN_PATH = "/alipay/login";
    private final String APP_LOGIN_PATH = "/alipay/applogin";
    private final String LOGIN_FAIL_PATH = "/alipay/loginFail";
    private final String LOGIN_SUCESS_PATH = "/alipay/loginSuccess";
    private final String LOGIN_CALLBACK_PATH = "/alipay/callback";
    private final String LOGOUT_PATH = "/alipay/logout";

    protected Object request(HttpServletRequest request) {
        if (!this.isUserLoggedIn(request)) {
            return this.alipayLogin(request);
        }
        String userId = (String)this.getUserId(request);
        String accessToken = this.getValidatedUserAccessToken(userId);
        return this.doLogic(request, accessToken);
    }

    private boolean isUserLoggedIn(HttpServletRequest request) {
        Object userId = this.getUserId(request);
        return userId != null && StringUtils.isNotBlank((CharSequence)userId.toString());
    }

    private Object getUserId(HttpServletRequest request) {
        return request.getSession().getAttribute("userId");
    }

    protected abstract Object doLogic(HttpServletRequest var1, String var2);

    @RequestMapping(value={"/alipay/login"})
    public Object alipayLogin(HttpServletRequest request) {
        String host = request.getHeader("host");
        String url = this.alipayAuthUrl + "/oauth2/publicAppAuthorize.htm?app_id=" + this.appId + "&redirect_uri=http://lunwenxu.com:8080/alipay/logincallback&scope=auth_user";
        return "redirect:" + url;
    }

    @RequestMapping(value={"/alipay/testlogin"})
    public Object testAlipayLogin(HttpServletRequest request, @RequestParam String appId, @RequestParam String redirectUrl, @RequestParam String appPrivateKey, @RequestParam String alipayPublicKey) {
        String url = this.alipayAuthUrl + "/oauth2/publicAppAuthorize.htm?app_id=" + appId + "&redirect_uri=" + (redirectUrl.startsWith("http://") ? redirectUrl : "http://" + redirectUrl) + ":8080/alipay/testlogincallback&scope=auth_user";
        HttpSession session = request.getSession();
        session.setAttribute("tempAppId", (Object)appId);
        session.setAttribute("tempAppPrivateKey", (Object)appPrivateKey);
        session.setAttribute("tempAlipayPublicKey", (Object)alipayPublicKey);
        return "redirect:" + url;
    }

    @RequestMapping(value={"/alipay/applogin"})
    public Object alipayApAuth(HttpServletRequest request) {
        String host = request.getHeader("host");
        String url = this.alipayAuthUrl + "/oauth2/appToAppAuth.htm?app_id=" + this.appId + "&redirect_uri=http://" + host + "/alipay/callback";
        return "redirect:" + url;
    }

    private String getValidatedUserAccessToken(String userId) {
        AlipayUser alipayUser = this.alipayUserService.loadByUserId(userId);
        if (alipayUser.getGmtTokenExpire().after(new Date())) {
            // empty if block
        }
        return alipayUser.getAccessToken();
    }

    @RequestMapping(value={"/testIndex"})
    public Object testLogin(HttpServletRequest request) {
        HttpSession session = request.getSession();
        if (session.getAttribute("userId") == null) {
            return this.alipayLogin(request);
        }
        return "index.html";
    }

    @Autowired
    public void setAlipayUserService(AlipayUserService alipayUserService) {
        this.alipayUserService = alipayUserService;
    }
}

