/*
 * Decompiled with CFR 0.152.
 */
package com.koubei.cavalry.architect.auth;

import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class OauthTestController {
    private static final Logger logger = LoggerFactory.getLogger(OauthTestController.class);
    @Value(value="${alipay.authUrl}")
    private String alipayAuthUrl;
    @Value(value="${alipay.appId}")
    private String appId;

    @RequestMapping(value={"/alipay/testauth"})
    public Object testauth(HttpServletRequest request, @RequestParam String appId, @RequestParam String domain, @RequestParam String privateKey, @RequestParam String alipayPublicKey) {
        try {
            String redirectUrl = URLEncoder.encode(domain + "/alipay/authcallback", "UTF-8");
            HttpSession session = request.getSession();
            session.setAttribute("tempAppId", (Object)appId);
            session.setAttribute("tempPrivateKey", (Object)privateKey);
            session.setAttribute("tempAlipayPublicKey", (Object)alipayPublicKey);
            session.setAttribute("isTestAuth", (Object)true);
            return "redirect:" + this.alipayAuthUrl + "?app_id=" + appId + "&scope=auth_user&redirect_uri=" + redirectUrl;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

