/*
 * Decompiled with CFR 0.152.
 */
package com.koubei.cavalry.architect;

import com.alibaba.druid.pool.DruidDataSource;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClient;
import com.google.common.collect.Lists;
import com.koubei.cavalry.architect.support.AlipayAuthFilter;
import com.koubei.cavalry.architect.support.DummyDataSource;
import com.koubei.cavalry.architect.support.DummyOss;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collection;
import javax.servlet.Filter;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.servlet.view.JstlView;

@Component
@Configuration
public class ConfigHolder {
    private final Logger logger = LoggerFactory.getLogger(ConfigHolder.class);
    @Value(value="${rds.host}")
    private String rdsHost;
    @Value(value="${rds.dbName}")
    private String rdsDbName;
    @Value(value="${rds.username}")
    private String rdsUsername;
    @Value(value="${rds.password}")
    private String rdsPassword;
    @Value(value="${oss.endpoint}")
    private String ossEndpoint;
    @Value(value="${oss.accessKeyId}")
    private String ossAccessKeyId;
    @Value(value="${oss.accessKeySecret}")
    private String ossAccessKeySecret;
    @Value(value="${ocs.username}")
    private String ocsUsername;
    @Value(value="${ocs.port}")
    private String ocsPort;
    @Value(value="${ocs.host}")
    private String ocsHost;
    private boolean dsAvailable;

    @Bean(initMethod="init", destroyMethod="close")
    public DataSource dataSource() {
        if (this.dsAvailable()) {
            DruidDataSource dataSource = new DruidDataSource();
            dataSource.setDriverClassName("com.mysql.jdbc.Driver");
            dataSource.setUrl(String.format("jdbc:mysql://%s/%s", this.rdsHost, this.rdsDbName));
            dataSource.setPassword(this.rdsPassword);
            dataSource.setUsername(this.rdsUsername);
            dataSource.setInitialSize(5);
            dataSource.setMaxActive(10);
            dataSource.setMinIdle(5);
            dataSource.setMaxWait(60000L);
            try {
                dataSource.setFilters("stat");
            }
            catch (SQLException e) {
                this.logger.error("init dataSource failed when setting filters.", (Throwable)e);
                return new DummyDataSource();
            }
            dataSource.setValidationQuery("SELECT 'x'");
            dataSource.setMinEvictableIdleTimeMillis(300000L);
            dataSource.setTimeBetweenEvictionRunsMillis(3000L);
            return dataSource;
        }
        return new DummyDataSource();
    }

    @Bean
    public OSS ossClient() {
        if (this.isOssAvailable()) {
            return new OSSClient(this.ossEndpoint, this.ossAccessKeyId, this.ossAccessKeySecret);
        }
        return new DummyOss();
    }

    @Bean
    public FilterRegistrationBean authFilter(AlipayAuthFilter alipayAuthFilter) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)alipayAuthFilter);
        registrationBean.setUrlPatterns((Collection)Lists.newArrayList((Object[])new String[]{"/welcome.html"}));
        return registrationBean;
    }

    @Bean
    public AlipayAuthFilter alipayAuthFilter() {
        return new AlipayAuthFilter();
    }

    @Bean
    public ViewResolver getViewResolver() {
        InternalResourceViewResolver resolver = new InternalResourceViewResolver();
        resolver.setPrefix("/META-INF/jsp/");
        resolver.setSuffix(".jsp");
        resolver.setViewClass(JstlView.class);
        return resolver;
    }

    private boolean dsAvailable() {
        if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.rdsHost, this.rdsDbName, this.rdsUsername, this.rdsPassword})) {
            return false;
        }
        try {
            Connection conn = DriverManager.getConnection(String.format("jdbc:mysql://%s/%s", this.rdsHost, this.rdsDbName), this.rdsUsername, this.rdsPassword);
            conn.close();
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public boolean isDsAvailable() {
        return this.dsAvailable;
    }

    public boolean isOssAvailable() {
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.ossEndpoint, this.ossAccessKeyId, this.ossAccessKeySecret});
    }

    public void setRdsHost(String rdsHost) {
        this.rdsHost = rdsHost;
    }

    public void setRdsDbName(String rdsDbName) {
        this.rdsDbName = rdsDbName;
    }

    public void setRdsUsername(String rdsUsername) {
        this.rdsUsername = rdsUsername;
    }

    public void setRdsPassword(String rdsPassword) {
        this.rdsPassword = rdsPassword;
    }

    public void setOssEndpoint(String ossEndpoint) {
        this.ossEndpoint = ossEndpoint;
    }

    public void setOssAccessKeyId(String ossAccessKeyId) {
        this.ossAccessKeyId = ossAccessKeyId;
    }

    public void setOssAccessKeySecret(String ossAccessKeySecret) {
        this.ossAccessKeySecret = ossAccessKeySecret;
    }
}

