/*
 * Decompiled with CFR 0.152.
 */
package com.kotlex.system.io;

import android.webkit.MimeTypeMap;
import com.kotlex.system.io.BufferedOutputStreamKt;
import com.kotlex.system.io.ClosableKt;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0002\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\f"}, d2={"mimeType", "", "Ljava/io/File;", "getMimeType", "(Ljava/io/File;)Ljava/lang/String;", "getMimeTypeFromUnKnownExtension", "extension", "deleteChildren", "", "tryCopy", "", "target", "system_release"})
public final class FileKt {
    @Nullable
    public static final String getMimeType(@NotNull File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String mime = MimeTypeMap.getSingleton().getMimeTypeFromExtension(FilesKt.getExtension((File)$receiver));
        if (mime == null) {
            mime = FileKt.getMimeTypeFromUnKnownExtension(FilesKt.getExtension((File)$receiver));
        }
        return mime;
    }

    public static final void deleteChildren(@NotNull File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        boolean success = true;
        if ($receiver.isDirectory()) {
            File[] $receiver$iv;
            File[] fileArray = $receiver.listFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileArray, (String)"listFiles()");
            File[] fileArray2 = $receiver$iv = fileArray;
            int n = fileArray2.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = fileArray2[i];
                boolean bl = false;
                success = success && it.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static final boolean tryCopy(@NotNull File $receiver, @NotNull File target) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        if (!target.getParentFile().exists()) {
            target.getParentFile().mkdirs();
        }
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            inputStream = new FileInputStream($receiver);
            bufferedInputStream = new BufferedInputStream(inputStream);
            fileOutputStream = new FileOutputStream(target);
            BufferedOutputStreamKt.writeTo$default(bufferedInputStream, fileOutputStream, 0, 2, null);
            bl = true;
        }
        catch (Exception exception) {
            InputStream inputStream2 = inputStream;
            if (inputStream2 != null) {
                ClosableKt.closeCatched(inputStream2);
            }
            BufferedInputStream bufferedInputStream2 = bufferedInputStream;
            if (bufferedInputStream2 != null) {
                ClosableKt.closeCatched(bufferedInputStream2);
            }
            FileOutputStream fileOutputStream2 = fileOutputStream;
            if (fileOutputStream2 != null) {
                ClosableKt.closeCatched(fileOutputStream2);
            }
            catch (Throwable throwable) {
                InputStream inputStream3 = inputStream;
                if (inputStream3 != null) {
                    ClosableKt.closeCatched(inputStream3);
                }
                BufferedInputStream bufferedInputStream3 = bufferedInputStream;
                if (bufferedInputStream3 != null) {
                    ClosableKt.closeCatched(bufferedInputStream3);
                }
                FileOutputStream fileOutputStream3 = fileOutputStream;
                if (fileOutputStream3 != null) {
                    ClosableKt.closeCatched(fileOutputStream3);
                }
                throw throwable;
            }
        }
        ClosableKt.closeCatched(inputStream);
        ClosableKt.closeCatched(bufferedInputStream);
        ClosableKt.closeCatched(fileOutputStream);
        return bl;
        return false;
    }

    private static final String getMimeTypeFromUnKnownExtension(String extension) {
        if (Intrinsics.areEqual((Object)extension, (Object)"webp")) {
            return "image/webp";
        }
        if (Intrinsics.areEqual((Object)extension, (Object)"weba")) {
            return "audio/webm";
        }
        return Intrinsics.areEqual((Object)extension, (Object)"webm") ? "video/webm" : null;
    }
}

