/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.util;

import com.kontakt.sdk.android.common.interfaces.SDKFunction;
import com.kontakt.sdk.android.common.interfaces.SDKThrowableFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JSONUtils {
    private static final JSONArray EMPTY_JSON_ARRAY = new JSONArray();

    private JSONUtils() {
    }

    public static boolean hasJSONKey(JSONObject jsonObject, String key) {
        return jsonObject.has(key) && !jsonObject.isNull(key);
    }

    public static String getString(JSONObject jsonObject, String key, String defaultValue) {
        try {
            return JSONUtils.hasJSONKey(jsonObject, key) ? jsonObject.getString(key) : defaultValue;
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    public static int getInt(JSONObject jsonObject, String key, int defaultValue) {
        try {
            return JSONUtils.hasJSONKey(jsonObject, key) ? jsonObject.getInt(key) : defaultValue;
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    public static long getLong(JSONObject jsonObject, String key, long defaultValue) {
        try {
            return JSONUtils.hasJSONKey(jsonObject, key) ? jsonObject.getLong(key) : defaultValue;
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    public static double getDouble(JSONObject jsonObject, String key, double defaultValue) {
        try {
            return JSONUtils.hasJSONKey(jsonObject, key) ? (double)jsonObject.getInt(key) : defaultValue;
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    public static UUID getUUID(JSONObject jsonObject, String key, UUID defaultValue) {
        try {
            return JSONUtils.hasJSONKey(jsonObject, key) ? UUID.fromString(jsonObject.getString(key)) : defaultValue;
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    public static UUID getUUIDOrNull(JSONObject jsonObject, String key) {
        return JSONUtils.getUUID(jsonObject, key, null);
    }

    public static String getStringOrNull(JSONObject jsonObject, String key) {
        return JSONUtils.getString(jsonObject, key, null);
    }

    public static boolean getBoolean(JSONObject jsonObject, String key, boolean defaultValue) {
        try {
            return JSONUtils.hasJSONKey(jsonObject, key) ? jsonObject.getBoolean(key) : defaultValue;
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Boolean getBooleanBoxed(JSONObject jsonObject, String key) {
        try {
            Object value = jsonObject.get(key);
            if (value == null) {
                return null;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return null;
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    public static JSONArray getJSONArray(JSONObject jsonObject, String key, JSONArray defaultValue) {
        try {
            return JSONUtils.hasJSONKey(jsonObject, key) ? jsonObject.getJSONArray(key) : defaultValue;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static JSONObject getJSONObject(JSONArray sourceObject, int index) {
        try {
            return sourceObject.getJSONObject(index);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static String getJSONArrayElement(JSONArray sourceArray, int index) {
        try {
            return sourceArray.getString(index);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T transformOrThrow(JSONObject jsonObject, SDKThrowableFunction<JSONObject, T, Exception> transformFunction) {
        try {
            return transformFunction.apply(jsonObject);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T transformOrThrow(JSONArray jsonArray, SDKThrowableFunction<JSONArray, T, Exception> transformFunction) {
        try {
            return transformFunction.apply(jsonArray);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> List<T> transformToListOrReturnEmpty(JSONObject jsonObject, String tag, SDKFunction<JSONObject, T> function) {
        try {
            JSONArray jsonArray;
            JSONArray jSONArray = jsonArray = JSONUtils.hasJSONKey(jsonObject, tag) ? jsonObject.getJSONArray(tag) : EMPTY_JSON_ARRAY;
            if (jsonArray.length() == 0) {
                return Collections.emptyList();
            }
            ArrayList<T> list = new ArrayList<T>();
            int size = jsonArray.length();
            for (int i = 0; i < size; ++i) {
                list.add(function.apply(jsonArray.getJSONObject(i)));
            }
            return list;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T transformOrReturnNull(JSONObject jsonObject, String jsonEntry, SDKFunction<JSONObject, T> convertFunction) {
        try {
            return JSONUtils.hasJSONKey(jsonObject, jsonEntry) ? (T)convertFunction.apply(jsonObject.getJSONObject(jsonEntry)) : null;
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }
}

