/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.util;

import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class HttpUtils {
    public static final int SC_BAD_REQUEST = 400;
    public static final int SC_CONFLICT = 409;
    public static final int SC_CREATED = 201;
    public static final int SC_FORBIDDEN = 403;
    public static final int SC_INTERNAL_SERVER_ERROR = 500;
    public static final int SC_NOT_FOUND = 404;
    public static final int SC_NOT_MODIFIED = 304;
    public static final int SC_OK = 200;
    public static final int SC_NO_CONTENT = 204;
    public static final int SC_SERVICE_UNAVAILABLE = 503;
    public static final int SC_UNAUTHORIZED = 401;
    public static final int SC_UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int SC_SEE_OTHER = 303;
    public static final int SC_METHOD_NOT_ALLOWED = 405;
    public static final int SC_UNPROCESSABLE_ENTITY = 422;
    public static final int SC_BAD_GATEWAY = 502;
    public static final int SC_GATEWAY_TIMEOUT = 504;

    private HttpUtils() {
    }

    public static <T> List<Map.Entry<String, String>> toUrlParameterList(String argumentName, Collection<T> argCollection) {
        SDKPreconditions.checkNotNullOrEmpty(argCollection, "Arguments array is empty or null.");
        SDKPreconditions.checkNotNullOrEmpty(argumentName, "Argument name is null or empty");
        ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(argCollection.size());
        for (T element : argCollection) {
            entries.add(new UrlParameter(argumentName, element instanceof String ? (String)element : element.toString()));
        }
        return entries;
    }

    public static <T> Map.Entry<String, String> toUrlParameter(String argumentName, String argumentValue) {
        SDKPreconditions.checkNotNull(argumentName);
        SDKPreconditions.checkNotNull(argumentValue);
        return new UrlParameter(argumentName, argumentValue);
    }

    private static class UrlParameter
    implements Map.Entry<String, String> {
        private final String key;
        private final String value;
        private final int hashCode;

        private UrlParameter(String key, String value) {
            this.key = key;
            this.value = value;
            this.hashCode = HashCodeBuilder.init().append(key).append(value).build();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !(o instanceof UrlParameter)) {
                return false;
            }
            UrlParameter urlParameter = (UrlParameter)o;
            return this.key.equals(urlParameter.key) && this.value.equals(urlParameter.value);
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String object) {
            throw new UnsupportedOperationException();
        }
    }
}

