/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.profile;

import android.os.Parcel;
import java.util.ArrayList;
import java.util.List;

public enum DeviceProfile {
    IBEACON(1),
    EDDYSTONE(2);

    final int activeProfileValue;

    private DeviceProfile(int activeProfileValue) {
        this.activeProfileValue = activeProfileValue;
    }

    public int getActiveProfileValue() {
        return this.activeProfileValue;
    }

    public static void writeToParcel(Parcel dest, List<DeviceProfile> deviceProfiles) {
        ArrayList<String> deviceProfilesString = new ArrayList<String>();
        for (DeviceProfile deviceProfile : deviceProfiles) {
            deviceProfilesString.add(deviceProfile.name());
        }
        dest.writeList(deviceProfilesString);
    }

    public static List<DeviceProfile> readFromParcel(Parcel in) {
        ArrayList<DeviceProfile> deviceProfileList = new ArrayList<DeviceProfile>();
        ArrayList deviceProfilesString = new ArrayList();
        in.readList(deviceProfilesString, null);
        for (String name : deviceProfilesString) {
            deviceProfileList.add(DeviceProfile.valueOf(name));
        }
        return deviceProfileList;
    }

    public static DeviceProfile getActiveProfile(int activeProfile) {
        for (DeviceProfile deviceProfile : DeviceProfile.values()) {
            if (deviceProfile.activeProfileValue != activeProfile) continue;
            return deviceProfile;
        }
        return null;
    }
}

