/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.AbstractModel;
import com.kontakt.sdk.android.common.model.Beacon;
import com.kontakt.sdk.android.common.model.IDevice;
import com.kontakt.sdk.android.common.model.IVenue;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.JSONUtils;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Venue
extends AbstractModel
implements IVenue {
    private final UUID id;
    private final String name;
    private final String description;
    private final int beaconsCount;
    private final String coverType;
    private final List<IDevice> devices;
    private final String imageUrl;
    private final UUID managerId;
    private final int hashCode;
    private final String longitude;
    private final String latitude;
    public static final Parcelable.Creator<Venue> CREATOR = new Parcelable.Creator<Venue>(){

        public Venue createFromParcel(Parcel input) {
            Builder builder = new Builder();
            Bundle bundle = input.readBundle(this.getClass().getClassLoader());
            int beaconsListSize = input.readInt();
            for (int index = 0; index < beaconsListSize; ++index) {
                Beacon beacon = (Beacon)Beacon.CREATOR.createFromParcel(input);
                builder.addDevice(beacon);
            }
            return builder.setId((UUID)bundle.getSerializable("id")).setName(bundle.getString("name")).setDescription(bundle.getString("description")).setCoverType(bundle.getString("coverType")).setDevicesCount(bundle.getInt("devicesCount")).setImageUrl(bundle.getString("image")).setManagerId((UUID)bundle.getSerializable("managerId")).setDatabaseId(bundle.getInt("databaseId")).setLatitude(bundle.getString("lat")).setLongitude(bundle.getString("lng")).build();
        }

        public Venue[] newArray(int size) {
            return new Venue[size];
        }
    };

    private Venue(Builder builder) {
        super(builder.databaseId);
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.coverType = builder.coverType;
        this.beaconsCount = builder.beaconsCount;
        this.imageUrl = builder.imageUrl;
        this.devices = Collections.unmodifiableList(builder.beacons);
        this.managerId = builder.managerId;
        this.latitude = builder.lat;
        this.longitude = builder.lng;
        this.hashCode = HashCodeBuilder.init().append(this.id).append(this.name).append(this.description).append(this.coverType).append(this.beaconsCount).append(this.imageUrl).append(this.devices).append(this.managerId).append(this.latitude).append(this.longitude).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof Venue)) {
            return false;
        }
        Venue venue = (Venue)o;
        return SDKEqualsBuilder.start().equals(this.id, venue.id).equals(this.description, venue.description).equals(this.coverType, venue.coverType).equals(this.beaconsCount, venue.beaconsCount).equals(this.imageUrl, venue.imageUrl).equals(this.devices, venue.devices).equals(this.managerId, venue.managerId).equals(this.latitude, venue.latitude).equals(this.longitude, venue.longitude).result();
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getCoverType() {
        return this.coverType;
    }

    @Override
    public List<IDevice> getDevices() {
        return this.devices;
    }

    @Override
    public UUID getManagerId() {
        return this.managerId;
    }

    @Override
    public int getDevicesCount() {
        return this.beaconsCount;
    }

    @Override
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Override
    public String getLatitude() {
        return this.latitude;
    }

    @Override
    public String getLongitude() {
        return this.longitude;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putSerializable("id", (Serializable)this.id);
        bundle.putSerializable("managerId", (Serializable)this.managerId);
        bundle.putString("name", this.name);
        bundle.putString("description", this.description);
        bundle.putString("coverType", this.coverType);
        bundle.putInt("devicesCount", this.beaconsCount);
        bundle.putString("image", this.imageUrl);
        bundle.putInt("databaseId", this.databaseId);
        bundle.putString("lng", this.longitude);
        bundle.putString("lat", this.latitude);
        dest.writeBundle(bundle);
        dest.writeInt(this.devices.size());
        for (IDevice beacon : this.devices) {
            beacon.writeToParcel(dest, 1);
        }
    }

    public static Venue from(JSONObject jsonObject) {
        try {
            ArrayList<IDevice> beaconsList = new ArrayList<IDevice>();
            if (jsonObject.has("devices")) {
                JSONArray beaconsArray = jsonObject.getJSONArray("devices");
                int limit = beaconsArray.length();
                for (int index = 0; index < limit; ++index) {
                    beaconsList.add(Beacon.from(beaconsArray.getJSONObject(index)));
                }
            }
            return new Builder().setId(JSONUtils.getUUIDOrNull(jsonObject, "id")).setManagerId(JSONUtils.getUUID(jsonObject, "managerId", null)).setName(JSONUtils.getStringOrNull(jsonObject, "name")).setDescription(JSONUtils.getStringOrNull(jsonObject, "description")).setCoverType(JSONUtils.getStringOrNull(jsonObject, "coverType")).setDevicesCount(JSONUtils.getInt(jsonObject, "devicesCount", 0)).setImageUrl(JSONUtils.getStringOrNull(jsonObject, "image")).addDevices(beaconsList).setLatitude(JSONUtils.getStringOrNull(jsonObject, "lat")).setLongitude(JSONUtils.getStringOrNull(jsonObject, "lng")).build();
        }
        catch (JSONException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final class Builder {
        private int databaseId;
        private UUID id;
        private String name;
        private String description;
        private String coverType;
        private int beaconsCount;
        private String imageUrl;
        private List<IDevice> beacons = new ArrayList<IDevice>();
        private UUID managerId;
        private String lat;
        private String lng;

        public Builder setDatabaseId(int databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder setId(UUID id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setCoverType(String coverType) {
            this.coverType = coverType;
            return this;
        }

        public Builder setDevicesCount(int beaconsCount) {
            this.beaconsCount = beaconsCount;
            return this;
        }

        public Builder setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public Builder addDevices(Collection<IDevice> beacons) {
            this.beacons.addAll(beacons);
            return this;
        }

        public Builder addDevice(IDevice beacon) {
            this.beacons.add(beacon);
            return this;
        }

        public Builder setManagerId(UUID managerId) {
            this.managerId = managerId;
            return this;
        }

        public Builder setLongitude(String lng) {
            this.lng = lng;
            return this;
        }

        public Builder setLatitude(String lat) {
            this.lat = lat;
            return this;
        }

        public Venue build() {
            return new Venue(this);
        }
    }
}

