/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.TimestampUtil;
import com.kontakt.sdk.android.common.util.JSONUtils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class SecureSingleConfig
implements Parcelable {
    private static final String UNIQUE_ID = "uniqueId";
    private static final String CONFIG = "config";
    private static final String CONFIGS = "configs";
    private final String uniqueId;
    private final String secureMessage;
    private final long unixTimestamp;
    public static final Parcelable.Creator<SecureSingleConfig> CREATOR = new Parcelable.Creator<SecureSingleConfig>(){

        public SecureSingleConfig createFromParcel(Parcel source) {
            return new SecureSingleConfig(source);
        }

        public SecureSingleConfig[] newArray(int size) {
            return new SecureSingleConfig[size];
        }
    };

    public SecureSingleConfig(String uniqueId, String secureMessage, long unixTimestamp) {
        this.uniqueId = uniqueId;
        this.secureMessage = secureMessage;
        this.unixTimestamp = unixTimestamp;
    }

    private SecureSingleConfig(Parcel source) {
        Bundle bundle = source.readBundle(this.getClass().getClassLoader());
        this.uniqueId = bundle.getString(UNIQUE_ID);
        this.secureMessage = bundle.getString("secure_config");
        this.unixTimestamp = bundle.getLong("timestamp");
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getSecureMessage() {
        return this.secureMessage;
    }

    public long getUnixTimestamp() {
        return this.unixTimestamp;
    }

    public String toString() {
        return "SecureSingleConfig{uniqueId='" + this.uniqueId + '\'' + ", secureMessage='" + this.secureMessage + '\'' + ", unixTimestamp=" + this.unixTimestamp + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putString(UNIQUE_ID, this.uniqueId);
        bundle.putString("secure_config", this.secureMessage);
        bundle.putLong("timestamp", this.unixTimestamp);
        dest.writeBundle(bundle);
    }

    public static final SecureSingleConfig fromJson(JSONObject object) {
        String uniqueId = JSONUtils.getStringOrNull(object, UNIQUE_ID);
        String config = JSONUtils.getStringOrNull(object, CONFIG);
        return new SecureSingleConfig(uniqueId, config, TimestampUtil.getTimestamp());
    }

    public static final List<SecureSingleConfig> fromListJson(JSONObject object) {
        JSONArray configs = JSONUtils.getJSONArray(object, CONFIGS, new JSONArray());
        ArrayList<SecureSingleConfig> secureConfigs = new ArrayList<SecureSingleConfig>();
        for (int i = 0; i < configs.length(); ++i) {
            secureConfigs.add(SecureSingleConfig.fromJson(JSONUtils.getJSONObject(configs, i)));
        }
        return secureConfigs;
    }
}

