/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import com.kontakt.sdk.android.common.util.JSONUtils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class SecureCommandResponse {
    private final String config;
    private final String uniqueId;

    private SecureCommandResponse(String config, String uniqueId) {
        this.config = config;
        this.uniqueId = uniqueId;
    }

    public String getConfig() {
        return this.config;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public static SecureCommandResponse from(JSONObject jsonObject) {
        String config = JSONUtils.getStringOrNull(jsonObject, "config");
        String uniqueId = JSONUtils.getStringOrNull(jsonObject, "uniqueId");
        return new SecureCommandResponse(config, uniqueId);
    }

    public static List<SecureCommandResponse> fromList(JSONObject jsonObject) {
        try {
            ArrayList<SecureCommandResponse> secureCommandResponses = new ArrayList<SecureCommandResponse>();
            JSONArray jsonArray = jsonObject.getJSONArray("commands");
            int commandsSize = jsonArray.length();
            for (int i = 0; i < commandsSize; ++i) {
                secureCommandResponses.add(SecureCommandResponse.from(jsonArray.getJSONObject(i)));
            }
            return secureCommandResponses;
        }
        catch (Exception e) {
            throw new IllegalStateException("No commands found");
        }
    }
}

