/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import com.kontakt.sdk.android.common.model.BeaconId;
import com.kontakt.sdk.android.common.model.EddystoneUID;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.Serializable;
import java.util.UUID;

public class ResolvedId
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ID_SEPARATOR = ":";
    private final String deviceId;
    private final String uniqueId;
    private Integer hashCode;

    public ResolvedId(String deviceId, String uniqueId) {
        this.deviceId = deviceId;
        this.uniqueId = uniqueId;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ResolvedId)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ResolvedId resolvedId = (ResolvedId)o;
        return SDKEqualsBuilder.start().equals(this.deviceId, resolvedId.deviceId).equals(this.uniqueId, resolvedId.uniqueId).result();
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = HashCodeBuilder.init().append(this.deviceId).append(this.uniqueId).build();
        }
        return this.hashCode;
    }

    public BeaconId getIBeaconId() {
        String[] splittedBeaconId = this.deviceId.split(ID_SEPARATOR);
        SDKPreconditions.checkArgument(splittedBeaconId.length == 3, "Incorrect iBeacon id format!");
        UUID proximity = UUID.fromString(splittedBeaconId[0]);
        int major = Integer.parseInt(splittedBeaconId[1]);
        int minor = Integer.parseInt(splittedBeaconId[2]);
        return BeaconId.of(proximity, major, minor);
    }

    public EddystoneUID getEddystoneUID() {
        String[] splittedEddystoneUID = this.deviceId.split(ID_SEPARATOR);
        SDKPreconditions.checkArgument(splittedEddystoneUID.length == 2, "Incorrect eddstone uid format!");
        String namespace = splittedEddystoneUID[0];
        String instanceId = splittedEddystoneUID[1];
        return EddystoneUID.of(namespace, instanceId);
    }

    public String getUniqueId() {
        return this.uniqueId;
    }
}

