/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.AbstractModel;
import com.kontakt.sdk.android.common.model.IProximityUUID;
import com.kontakt.sdk.android.common.util.JSONUtils;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProximityUUID
extends AbstractModel
implements IProximityUUID,
Parcelable {
    public static final Parcelable.Creator<ProximityUUID> CREATOR = new Parcelable.Creator<ProximityUUID>(){

        public ProximityUUID createFromParcel(Parcel source) {
            Bundle bundle = source.readBundle(this.getClass().getClassLoader());
            return new Builder().setDatabaseId(bundle.getInt("databaseId")).setProximityUUID((UUID)bundle.getSerializable(ProximityUUID.PROXIMITY)).setSecureProximityUUID((UUID)bundle.getSerializable("secureProximity")).setShuffled(bundle.getBoolean(ProximityUUID.SHUFFLED)).setShared(bundle.getBoolean("shared")).build();
        }

        public ProximityUUID[] newArray(int size) {
            return new ProximityUUID[size];
        }
    };
    private static final String PROXIMITY = "proximity";
    private static final String SHUFFLED = "shuffled";
    private static final String PROXIMITIES = "proximities";
    private final UUID proximityUUID;
    private final UUID secureProximityUUID;
    private final boolean shuffled;
    private final boolean shared;

    private ProximityUUID(Builder builder) {
        super(builder.databaseId);
        this.proximityUUID = builder.proximityUUID;
        this.secureProximityUUID = builder.secureProximityUUID;
        this.shuffled = builder.shuffled;
        this.shared = builder.shared;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putSerializable(PROXIMITY, (Serializable)this.proximityUUID);
        bundle.putSerializable("secureProximity", (Serializable)this.secureProximityUUID);
        bundle.putBoolean(SHUFFLED, this.shuffled);
        bundle.putInt("databaseId", this.databaseId);
        bundle.putBoolean("shared", this.shared);
        dest.writeBundle(bundle);
    }

    @Override
    public UUID getProximity() {
        return this.proximityUUID;
    }

    @Override
    public UUID getSecureProximity() {
        return this.secureProximityUUID;
    }

    @Override
    public boolean isShuffled() {
        return this.shuffled;
    }

    @Override
    public boolean isShared() {
        return this.shared;
    }

    public static IProximityUUID from(JSONObject jsonObject) {
        UUID proximity = JSONUtils.getUUIDOrNull(jsonObject, PROXIMITY);
        UUID secureProximity = JSONUtils.getUUIDOrNull(jsonObject, "secureProximity");
        boolean shuffled = JSONUtils.getBoolean(jsonObject, SHUFFLED, false);
        boolean shared = JSONUtils.getBoolean(jsonObject, "shared", false);
        return new Builder().setShuffled(shuffled).setProximityUUID(proximity).setSecureProximityUUID(secureProximity).setShared(shared).build();
    }

    public static List<IProximityUUID> fromList(JSONObject jsonObject) {
        try {
            ArrayList<IProximityUUID> proximities = new ArrayList<IProximityUUID>();
            JSONArray jsonArray = jsonObject.getJSONArray(PROXIMITIES);
            for (int i = 0; i < jsonArray.length(); ++i) {
                proximities.add(ProximityUUID.from(jsonArray.getJSONObject(i)));
            }
            return proximities;
        }
        catch (JSONException e) {
            throw new IllegalStateException("No proximities found");
        }
    }

    public static class Builder {
        private int databaseId;
        private UUID proximityUUID;
        private UUID secureProximityUUID;
        private boolean shuffled;
        private boolean shared;

        public Builder setDatabaseId(int databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder setProximityUUID(UUID proximityUUID) {
            SDKPreconditions.checkNotNull(proximityUUID, "Proximity UUID cannot be null");
            this.proximityUUID = proximityUUID;
            return this;
        }

        public Builder setSecureProximityUUID(UUID secureProximityUUID) {
            SDKPreconditions.checkNotNull(secureProximityUUID, "Secure proximity UUID cannot be null");
            this.secureProximityUUID = secureProximityUUID;
            return this;
        }

        public Builder setShuffled(boolean shuffled) {
            this.shuffled = shuffled;
            return this;
        }

        public Builder setShared(boolean shared) {
            this.shared = shared;
            return this;
        }

        public ProximityUUID build() {
            return new ProximityUUID(this);
        }
    }
}

