/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.AbstractModel;
import com.kontakt.sdk.android.common.model.IPreset;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.JSONUtils;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import java.io.Serializable;
import java.util.UUID;
import org.json.JSONObject;

public class Preset
extends AbstractModel
implements IPreset {
    private final UUID proximityUUID;
    private final int interval;
    private final int txPower;
    private final String name;
    private final String description;
    private final int hashCode;
    public static final Parcelable.Creator<Preset> CREATOR = new Parcelable.Creator<Preset>(){

        public Preset createFromParcel(Parcel source) {
            Bundle bundle = source.readBundle(this.getClass().getClassLoader());
            return new Builder().setProximityUUID((UUID)bundle.getSerializable("proximity")).setInterval(bundle.getInt("interval")).setTxPower(bundle.getInt("txPower")).setName(bundle.getString("name")).setDescription(bundle.getString("description")).setDatabaseId(bundle.getInt("databaseId")).build();
        }

        public Preset[] newArray(int size) {
            return new Preset[size];
        }
    };

    private Preset(Builder builder) {
        super(builder.databaseId);
        this.proximityUUID = builder.proximityUUID;
        this.interval = builder.interval;
        this.txPower = builder.txPower;
        this.name = builder.name;
        this.description = builder.description;
        this.hashCode = HashCodeBuilder.init().append(this.proximityUUID).append(this.interval).append(this.txPower).append(this.name).append(this.description).build();
    }

    @Override
    public UUID getProximityUUID() {
        return this.proximityUUID;
    }

    @Override
    public int getInterval() {
        return this.interval;
    }

    @Override
    public int getTxPower() {
        return this.txPower;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Preset)) {
            return false;
        }
        Preset profile = (Preset)obj;
        return SDKEqualsBuilder.start().equals(this.proximityUUID, profile.proximityUUID).equals(this.interval, profile.interval).equals(this.txPower, profile.txPower).equals(this.name, profile.name).equals(this.description, profile.description).result();
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putSerializable("proximity", (Serializable)this.proximityUUID);
        bundle.putInt("interval", this.interval);
        bundle.putInt("txPower", this.txPower);
        bundle.putString("name", this.name);
        bundle.putString("description", this.description);
        bundle.putInt("databaseId", this.databaseId);
        dest.writeBundle(bundle);
    }

    public static Preset from(JSONObject jsonObject) {
        return new Builder().setProximityUUID(JSONUtils.getUUIDOrNull(jsonObject, "proximity")).setInterval(JSONUtils.getInt(jsonObject, "interval", 0)).setTxPower(JSONUtils.getInt(jsonObject, "txPower", 0)).setName(JSONUtils.getStringOrNull(jsonObject, "name")).setDescription(JSONUtils.getStringOrNull(jsonObject, "description")).build();
    }

    public static final class Builder {
        private int databaseId;
        private UUID proximityUUID;
        private int interval = 0;
        private int txPower = -1;
        private String name;
        private String description;

        public Builder setDatabaseId(int databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Preset build() {
            return new Preset(this);
        }

        public Builder setProximityUUID(UUID proximity) {
            this.proximityUUID = proximity;
            return this;
        }

        public Builder setInterval(int interval) {
            this.interval = interval;
            return this;
        }

        public Builder setTxPower(int txPower) {
            this.txPower = txPower;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }
    }
}

