/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.AbstractModel;
import com.kontakt.sdk.android.common.model.INamespace;
import com.kontakt.sdk.android.common.util.JSONUtils;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Namespace
extends AbstractModel
implements INamespace,
Parcelable {
    public static final Parcelable.Creator<Namespace> CREATOR = new Parcelable.Creator<Namespace>(){

        public Namespace createFromParcel(Parcel source) {
            Bundle bundle = source.readBundle(this.getClass().getClassLoader());
            return new Builder().setDatabaseId(bundle.getInt("databaseId")).setNamespace(bundle.getString("namespace")).setSecureNamespace(bundle.getString("secureNamespace")).setShuffled(bundle.getBoolean("shuffled")).setShared(bundle.getBoolean("shared")).build();
        }

        public Namespace[] newArray(int size) {
            return new Namespace[size];
        }
    };
    private final String namespace;
    private final String secureNamespace;
    private final boolean shuffled;
    private final boolean shared;

    private Namespace(Builder builder) {
        super(builder.databaseId);
        this.namespace = builder.namespace;
        this.secureNamespace = builder.secureNamespace;
        this.shuffled = builder.shuffled;
        this.shared = builder.shared;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getSecureNamespace() {
        return this.secureNamespace;
    }

    @Override
    public boolean isShuffled() {
        return this.shuffled;
    }

    @Override
    public boolean isShared() {
        return this.shared;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putString("namespace", this.namespace);
        bundle.putString("secureNamespace", this.secureNamespace);
        bundle.putBoolean("shuffled", this.shuffled);
        bundle.putInt("databaseId", this.databaseId);
        bundle.putBoolean("shared", this.shared);
        dest.writeBundle(bundle);
    }

    public static INamespace from(JSONObject jsonObject) {
        String namespace = JSONUtils.getStringOrNull(jsonObject, "namespace");
        String secureNamespace = JSONUtils.getStringOrNull(jsonObject, "secureNamespace");
        boolean shuffled = JSONUtils.getBoolean(jsonObject, "shuffled", false);
        boolean shared = JSONUtils.getBoolean(jsonObject, "shared", false);
        return new Builder().setShuffled(shuffled).setNamespace(namespace).setSecureNamespace(secureNamespace).setShared(shared).build();
    }

    public static List<INamespace> fromList(JSONObject jsonObject) {
        try {
            ArrayList<INamespace> namespaces = new ArrayList<INamespace>();
            JSONArray jsonArray = jsonObject.getJSONArray("namespaces");
            for (int i = 0; i < jsonArray.length(); ++i) {
                namespaces.add(Namespace.from(jsonArray.getJSONObject(i)));
            }
            return namespaces;
        }
        catch (JSONException e) {
            throw new IllegalStateException("No namespaces found");
        }
    }

    public static class Builder {
        private int databaseId;
        private String namespace;
        private String secureNamespace;
        private boolean shuffled;
        private boolean shared;

        public Builder setDatabaseId(int databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder setNamespace(String namespace) {
            SDKPreconditions.checkNotNull(namespace, "Namespace cannot be null");
            this.namespace = namespace;
            return this;
        }

        public Builder setSecureNamespace(String secureNamespace) {
            SDKPreconditions.checkNotNull(secureNamespace, "Secure namespace cannot be null");
            this.secureNamespace = secureNamespace;
            return this;
        }

        public Builder setShuffled(boolean shuffled) {
            this.shuffled = shuffled;
            return this;
        }

        public Builder setShared(boolean shared) {
            this.shared = shared;
            return this;
        }

        public Namespace build() {
            return new Namespace(this);
        }
    }
}

