/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.AbstractModel;
import com.kontakt.sdk.android.common.model.Company;
import com.kontakt.sdk.android.common.model.Counters;
import com.kontakt.sdk.android.common.model.ICompany;
import com.kontakt.sdk.android.common.model.ICounters;
import com.kontakt.sdk.android.common.model.IManager;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.JSONUtils;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Manager
extends AbstractModel
implements Comparable<Manager>,
IManager {
    private final UUID id;
    private final UUID supervisorId;
    private final String firstName;
    private final String lastName;
    private final ICompany company;
    private final String email;
    private final String uniqueId;
    private final IManager.Role role;
    private final ICounters counters;
    private final int hashCode;
    public static final Parcelable.Creator<Manager> CREATOR = new Parcelable.Creator<Manager>(){

        public Manager createFromParcel(Parcel input) {
            Bundle bundle = input.readBundle(this.getClass().getClassLoader());
            return new Builder().setId((UUID)bundle.getSerializable("id")).setSupervisorId((UUID)bundle.getSerializable("supervisorId")).setFirstName(bundle.getString("firstName")).setLastName(bundle.getString("lastName")).setCompany((Company)bundle.getParcelable("company")).setEmail(bundle.getString("email")).setUniqueId(bundle.getString("uniqueId")).setRole((IManager.Role)((Object)bundle.getSerializable("role"))).setDatabaseId(bundle.getInt("databaseId")).setCounters((ICounters)bundle.getParcelable("counters")).build();
        }

        public Manager[] newArray(int size) {
            return new Manager[size];
        }
    };

    private Manager(Builder builder) {
        super(builder.databaseId);
        this.id = builder.id;
        this.firstName = builder.firstName;
        this.supervisorId = builder.supervisorId;
        this.lastName = builder.lastName;
        this.company = builder.company;
        this.email = builder.email;
        this.uniqueId = builder.uniqueId;
        this.role = builder.role;
        this.counters = builder.counters;
        this.hashCode = HashCodeBuilder.init().append(this.id).append(this.firstName).append(this.supervisorId).append(this.lastName).append(this.company).append(this.email).append(this.uniqueId).append((Object)this.role).append(this.counters).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof Manager)) {
            return false;
        }
        Manager manager = (Manager)o;
        return SDKEqualsBuilder.start().equals(this.id, manager.id).equals(this.firstName, manager.firstName).equals(this.supervisorId, manager.supervisorId).equals(this.lastName, manager.lastName).equals(this.company, manager.company).equals(this.email, manager.email).equals(this.uniqueId, manager.uniqueId).equals((Object)this.role, (Object)manager.role).equals(this.counters, manager.counters).result();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "Manager{email='" + this.email + '\'' + ", role=" + (Object)((Object)this.role) + '}';
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public UUID getSupervisorId() {
        return this.supervisorId;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public ICompany getCompany() {
        return this.company;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public IManager.Role getRole() {
        return this.role;
    }

    @Override
    public ICounters getCounters() {
        return this.counters;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putSerializable("id", (Serializable)this.id);
        bundle.putSerializable("supervisorId", (Serializable)this.supervisorId);
        bundle.putString("firstName", this.firstName);
        bundle.putString("lastName", this.lastName);
        bundle.putParcelable("company", (Parcelable)this.company);
        bundle.putString("email", this.email);
        bundle.putString("uniqueId", this.uniqueId);
        bundle.putSerializable("role", (Serializable)((Object)this.role));
        bundle.putInt("databaseId", this.databaseId);
        bundle.putParcelable("counters", (Parcelable)this.counters);
        dest.writeBundle(bundle);
    }

    @Override
    public int compareTo(Manager another) {
        if (another == null || another.uniqueId == null) {
            return 1;
        }
        if (this.uniqueId == null) {
            return -1;
        }
        return this.uniqueId.compareTo(another.uniqueId);
    }

    public static Manager from(JSONObject jsonObject) {
        try {
            UUID id = JSONUtils.getUUIDOrNull(jsonObject, "id");
            UUID supervisorId = JSONUtils.getUUIDOrNull(jsonObject, "supervisorId");
            String firstName = JSONUtils.getStringOrNull(jsonObject, "firstName");
            String lastName = JSONUtils.getStringOrNull(jsonObject, "lastName");
            Company company = JSONUtils.hasJSONKey(jsonObject, "company") ? Company.from(jsonObject.getJSONObject("company")) : null;
            String email = JSONUtils.getStringOrNull(jsonObject, "email");
            String uniqueID = JSONUtils.getStringOrNull(jsonObject, "uniqueId");
            ICounters counters = JSONUtils.hasJSONKey(jsonObject, "counters") ? Counters.from(jsonObject.getJSONObject("counters")) : null;
            IManager.Role role = JSONUtils.hasJSONKey(jsonObject, "role") ? IManager.Role.valueOf(JSONUtils.getString(jsonObject, "role", null)) : null;
            return new Builder().setId(id).setSupervisorId(supervisorId).setFirstName(firstName).setLastName(lastName).setCompany(company).setEmail(email).setUniqueId(uniqueID).setCounters(counters).setRole(role).build();
        }
        catch (JSONException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Set<Manager> from(JSONArray jsonArray) {
        HashSet<Manager> managerSet = new HashSet<Manager>();
        int limit = jsonArray.length();
        for (int index = 0; index < limit; ++index) {
            try {
                managerSet.add(Manager.from(jsonArray.getJSONObject(index)));
                continue;
            }
            catch (JSONException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return managerSet;
    }

    public static final class Builder {
        private int databaseId;
        private UUID id;
        private UUID supervisorId;
        private String firstName;
        private String lastName;
        private ICompany company;
        private String email;
        private String uniqueId;
        private ICounters counters;
        private IManager.Role role;

        public Builder setDatabaseId(int databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder setId(UUID id) {
            this.id = id;
            return this;
        }

        public Builder setFirstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public Builder setLastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public Builder setCompany(ICompany company) {
            this.company = company;
            return this;
        }

        public Builder setEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public Builder setRole(IManager.Role role) {
            this.role = role;
            return this;
        }

        public Builder setSupervisorId(UUID supervisorId) {
            this.supervisorId = supervisorId;
            return this;
        }

        public Builder setCounters(ICounters counters) {
            this.counters = counters;
            return this;
        }

        public Manager build() {
            return new Manager(this);
        }
    }
}

