/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.BeaconId;
import com.kontakt.sdk.android.common.model.IFutureId;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.JSONUtils;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class IBeaconFutureId
implements IFutureId<BeaconId> {
    public static final Parcelable.Creator<IBeaconFutureId> CREATOR = new Parcelable.Creator<IBeaconFutureId>(){

        public IBeaconFutureId createFromParcel(Parcel source) {
            return new IBeaconFutureId(source);
        }

        public IBeaconFutureId[] newArray(int size) {
            return new IBeaconFutureId[size];
        }
    };
    private String uniqueId;
    private BeaconId queriedBy;
    private BeaconId resolved;
    private List<BeaconId> futureIds;

    public IBeaconFutureId() {
    }

    private IBeaconFutureId(Parcel source) {
        Bundle bundle = source.readBundle(this.getClass().getClassLoader());
        this.queriedBy = (BeaconId)bundle.getParcelable("queriedBy");
        this.resolved = (BeaconId)bundle.getParcelable("resolved");
        this.futureIds = bundle.getParcelableArrayList("futureId");
        this.uniqueId = bundle.getString("uniqueId");
    }

    @Override
    public BeaconId getQueriedBy() {
        return this.queriedBy;
    }

    public void setQueriedBy(BeaconId queriedBy) {
        this.queriedBy = queriedBy;
    }

    @Override
    public BeaconId getResolved() {
        return this.resolved;
    }

    public void setResolved(BeaconId resolved) {
        this.resolved = resolved;
    }

    @Override
    public List<BeaconId> getFutureIds() {
        return this.futureIds;
    }

    public void setFutureIds(List<BeaconId> futureIds) {
        this.futureIds = futureIds;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof IBeaconFutureId)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        IBeaconFutureId other = (IBeaconFutureId)o;
        return SDKEqualsBuilder.start().equals(this.resolved, other.resolved).equals(this.queriedBy, other.queriedBy).equals(this.futureIds, other.futureIds).equals(this.uniqueId, other.uniqueId).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.resolved).append(this.queriedBy).append(this.futureIds).append(this.uniqueId).build();
    }

    public static IBeaconFutureId from(JSONObject jsonObject) {
        String uniqueId = JSONUtils.getStringOrNull(jsonObject, "uniqueId");
        String queriedBy = JSONUtils.getStringOrNull(jsonObject, "queriedBy");
        BeaconId queriedByBeaconId = BeaconId.fromQueriedBy(queriedBy);
        BeaconId resolvedBeaconId = BeaconId.fromJSONObject(jsonObject);
        List<BeaconId> futureBeaconIds = BeaconId.getIBeaconFutureIds(jsonObject);
        IBeaconFutureId iBeaconShuffles = new IBeaconFutureId();
        iBeaconShuffles.setUniqueId(uniqueId);
        iBeaconShuffles.setQueriedBy(queriedByBeaconId);
        iBeaconShuffles.setResolved(resolvedBeaconId);
        iBeaconShuffles.setFutureIds(futureBeaconIds);
        return iBeaconShuffles;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putString("uniqueId", this.uniqueId);
        bundle.putParcelable("queriedBy", (Parcelable)this.queriedBy);
        bundle.putParcelable("resolved", (Parcelable)this.resolved);
        bundle.putParcelableArrayList("futureId", (ArrayList)this.futureIds);
        dest.writeBundle(bundle);
    }

    public int describeContents() {
        return 0;
    }
}

