/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.AbstractModel;
import com.kontakt.sdk.android.common.model.DeviceType;
import com.kontakt.sdk.android.common.model.IFirmware;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.JSONUtils;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

public class Firmware
extends AbstractModel
implements IFirmware {
    private final UUID id;
    private final String name;
    private final String description;
    private final String validVersions;
    private final boolean important;
    private final String url;
    private final DeviceType deviceType;
    private final boolean scheduled;
    private final boolean optional;
    private final ArrayList<String> deviceUniqueIds;
    private final int hashCode;
    public static final Parcelable.Creator<Firmware> CREATOR = new Parcelable.Creator<Firmware>(){

        public Firmware createFromParcel(Parcel parcel) {
            Bundle bundle = parcel.readBundle(this.getClass().getClassLoader());
            return new Builder().setId((UUID)bundle.getSerializable("id")).setImportant(bundle.getBoolean("important")).setDescription(bundle.getString("description")).setValidVersions(bundle.getString("validVersions")).setName(bundle.getString("name")).setUrl(bundle.getString("url")).setDatabaseId(bundle.getInt("databaseId")).setDeviceType((DeviceType)((Object)bundle.getSerializable("deviceType"))).setScheduled(bundle.getBoolean("scheduled")).setOptional(bundle.getBoolean("optional")).setDeviceUniqueIds(bundle.getStringArrayList("uniqueId")).build();
        }

        public Firmware[] newArray(int size) {
            return new Firmware[size];
        }
    };

    private Firmware(Builder builder) {
        super(builder.databaseId);
        this.id = builder.id;
        this.important = builder.important;
        this.description = builder.description;
        this.validVersions = builder.validVersions;
        this.name = builder.name;
        this.url = builder.url;
        this.deviceType = builder.deviceType;
        this.scheduled = builder.scheduled;
        this.optional = builder.optional;
        List strings = Collections.unmodifiableList(builder.deviceUniqueIds);
        this.deviceUniqueIds = new ArrayList(strings);
        this.hashCode = HashCodeBuilder.init().append(this.id).build();
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getValidVersions() {
        return this.validVersions;
    }

    @Override
    public boolean isImportant() {
        return this.important;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    @Override
    public boolean isScheduled() {
        return this.scheduled;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public ArrayList<String> getDeviceUniqueIdList() {
        return this.deviceUniqueIds;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putSerializable("id", (Serializable)this.id);
        bundle.putBoolean("important", this.important);
        bundle.putString("validVersions", this.validVersions);
        bundle.putString("name", this.name);
        bundle.putString("description", this.description);
        bundle.putString("url", this.url);
        bundle.putInt("databaseId", this.databaseId);
        bundle.putSerializable("deviceType", (Serializable)((Object)this.deviceType));
        bundle.putBoolean("scheduled", this.scheduled);
        bundle.putBoolean("optional", this.optional);
        bundle.putStringArrayList("uniqueId", this.deviceUniqueIds);
        dest.writeBundle(bundle);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof Firmware)) {
            return false;
        }
        Firmware firmware = (Firmware)o;
        return SDKEqualsBuilder.start().equals(this.id, firmware.id).result();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static Firmware from(JSONObject jsonObject) {
        String deviceTypeJsonValue = JSONUtils.getString(jsonObject, "deviceType", null);
        JSONArray uniqueIdsJsonArray = JSONUtils.getJSONArray(jsonObject, "uniqueId", new JSONArray());
        ArrayList<String> uniqueIds = new ArrayList<String>();
        int uniqueIdSize = uniqueIdsJsonArray.length();
        for (int i = 0; i < uniqueIdSize; ++i) {
            uniqueIds.add(JSONUtils.getJSONArrayElement(uniqueIdsJsonArray, i));
        }
        return new Builder().setId(JSONUtils.getUUIDOrNull(jsonObject, "id")).setImportant(JSONUtils.getBoolean(jsonObject, "important", false)).setValidVersions(JSONUtils.getStringOrNull(jsonObject, "validVersions")).setName(JSONUtils.getStringOrNull(jsonObject, "name")).setDescription(JSONUtils.getStringOrNull(jsonObject, "description")).setUrl(JSONUtils.getString(jsonObject, "url", null)).setScheduled(JSONUtils.getBoolean(jsonObject, "scheduled", false)).setOptional(JSONUtils.getBoolean(jsonObject, "optional", false)).setDeviceType(deviceTypeJsonValue == null ? null : DeviceType.valueOf(deviceTypeJsonValue)).setDeviceUniqueIds(uniqueIds).build();
    }

    public static List<IFirmware> fromList(JSONObject sourceObject) {
        try {
            JSONArray jsonArray = JSONUtils.getJSONArray(sourceObject, "firmwares", new JSONArray());
            int jsonArraySize = jsonArray.length();
            ArrayList<IFirmware> firmwares = new ArrayList<IFirmware>();
            for (int i = 0; i < jsonArraySize; ++i) {
                firmwares.add(Firmware.from(jsonArray.getJSONObject(i)));
            }
            return firmwares;
        }
        catch (Exception e) {
            throw new IllegalStateException("No firmwares found");
        }
    }

    public static final class Builder {
        private int databaseId;
        private UUID id;
        private boolean important;
        private String validVersions;
        private String name;
        private String description;
        private String url;
        private DeviceType deviceType;
        private boolean scheduled;
        private boolean optional;
        private ArrayList<String> deviceUniqueIds;

        public Builder setDatabaseId(int databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder setId(UUID id) {
            this.id = id;
            return this;
        }

        public Builder setImportant(boolean important) {
            this.important = important;
            return this;
        }

        public Builder setValidVersions(String validVersions) {
            this.validVersions = validVersions;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setDeviceType(DeviceType deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public Builder setScheduled(boolean scheduled) {
            this.scheduled = scheduled;
            return this;
        }

        public Builder setOptional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public Builder setDeviceUniqueIds(ArrayList<String> deviceUniqueIds) {
            this.deviceUniqueIds = deviceUniqueIds;
            return this;
        }

        public Firmware build() {
            return new Firmware(this);
        }
    }
}

