/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.model.Event;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EventPacket
implements Parcelable {
    private static final String TAG = "EventPacket";
    private static final String TIMESTAMP = "timestamp";
    private static final String EVENTS = "events";
    private final long timestamp;
    private final List<Event> events;
    public static final Parcelable.Creator<EventPacket> CREATOR = new Parcelable.Creator<EventPacket>(){

        public EventPacket createFromParcel(Parcel source) {
            return new EventPacket(source);
        }

        public EventPacket[] newArray(int size) {
            return new EventPacket[size];
        }
    };

    private EventPacket(Builder builder) {
        this.timestamp = builder.timestamp;
        this.events = builder.events;
    }

    private EventPacket(Parcel source) {
        this.events = new ArrayList<Event>();
        Bundle bundle = source.readBundle(this.getClass().getClassLoader());
        this.timestamp = bundle.getLong(TIMESTAMP);
        source.readTypedList(this.events, Event.CREATOR);
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putLong(TIMESTAMP, this.timestamp);
        dest.writeBundle(bundle);
        dest.writeTypedList(this.events);
    }

    public static JSONObject toJSONObject(EventPacket eventPacket) {
        try {
            List<Event> events = eventPacket.getEvents();
            JSONArray jsonEvents = Event.toJSONArray(events);
            JSONObject payload = new JSONObject();
            payload.put(TIMESTAMP, eventPacket.getTimestamp());
            payload.put(EVENTS, (Object)jsonEvents);
            return payload;
        }
        catch (JSONException e) {
            Logger.e("EventPacket Error occurred when try to transform monitoring event packet to JSON", e);
            throw new IllegalArgumentException(e);
        }
    }

    public static class Builder {
        private long timestamp;
        private List<Event> events;

        public Builder setEvents(List<Event> events) {
            SDKPreconditions.checkNotNullOrEmpty(events, "Events list cannot be null or empty");
            this.events = events;
            return this;
        }

        public Builder setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public EventPacket build() {
            return new EventPacket(this);
        }
    }
}

