/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.model.EventType;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Event
implements Parcelable {
    private static final String TAG = "MonitoringEvent";
    private static final String UNIQUE_ID = "uniqueId";
    private static final String TIMESTAMP = "timestamp";
    private static final String BATTERY_POWER = "batteryPower";
    private static final String BATTERY_LEVEL = "batteryLevel";
    public static final Parcelable.Creator<Event> CREATOR = new Parcelable.Creator<Event>(){

        public Event createFromParcel(Parcel source) {
            return new Event(source);
        }

        public Event[] newArray(int size) {
            return new Event[size];
        }
    };
    public static final String TYPE = "type";
    private final long timestamp;
    private final int batteryPower;
    private final String uniqueId;
    private final EventType type;

    public Event(EventType type, String uniqueId, int batteryPower, long timestamp) {
        this.type = type;
        this.timestamp = timestamp / 1000L;
        this.batteryPower = batteryPower;
        this.uniqueId = uniqueId;
    }

    private Event(Parcel source) {
        Bundle bundle = source.readBundle(this.getClass().getClassLoader());
        this.type = EventType.valueOf(bundle.getString(TYPE));
        this.timestamp = bundle.getLong(TIMESTAMP);
        this.uniqueId = bundle.getString(UNIQUE_ID);
        this.batteryPower = bundle.getInt(BATTERY_POWER);
    }

    public static Event of(RemoteBluetoothDevice device, EventType eventType) {
        return new Event(eventType, device.getUniqueId(), device.getBatteryPower(), device.getTimestamp());
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getBatteryPower() {
        return this.batteryPower;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public EventType getType() {
        return this.type;
    }

    public static JSONObject toJSONObject(Event event) {
        try {
            JSONObject jsonEvent = new JSONObject();
            jsonEvent.put(UNIQUE_ID, (Object)event.uniqueId);
            jsonEvent.put(BATTERY_LEVEL, event.batteryPower);
            jsonEvent.put(TIMESTAMP, event.timestamp);
            jsonEvent.put(TYPE, (Object)event.type.name());
            return jsonEvent;
        }
        catch (JSONException e) {
            Logger.e("MonitoringEvent Error occurred when try to transform monitoring event to JSON", e);
            throw new IllegalArgumentException(e);
        }
    }

    public static JSONArray toJSONArray(List<Event> monitoringEvents) {
        JSONArray events = new JSONArray();
        for (Event event : monitoringEvents) {
            events.put((Object)Event.toJSONObject(event));
        }
        return events;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putString(TYPE, this.type.name());
        bundle.putString(UNIQUE_ID, this.uniqueId);
        bundle.putLong(TIMESTAMP, this.timestamp);
        bundle.putInt(BATTERY_POWER, this.batteryPower);
        dest.writeBundle(bundle);
    }
}

