/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.profile.IEddystoneDevice;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.JSONUtils;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EddystoneUID
implements Parcelable {
    public static final Parcelable.Creator<EddystoneUID> CREATOR = new Parcelable.Creator<EddystoneUID>(){

        public EddystoneUID createFromParcel(Parcel source) {
            return new EddystoneUID(source);
        }

        public EddystoneUID[] newArray(int size) {
            return new EddystoneUID[size];
        }
    };
    private static final String NAMESPACE = "namespace";
    private static final String INSTANCE_ID = "instanceId";
    private static final String FUTURE_SHUFFLES = "futureId";
    private static final String EDDYSTONE = "EDDYSTONE";
    private String namespace;
    private String instanceId;
    Integer hashCode = null;

    public static EddystoneUID of(String namespace, String instanceId) {
        return new EddystoneUID(namespace, instanceId);
    }

    public static EddystoneUID of(IEddystoneDevice fakeDevice) {
        return new EddystoneUID(fakeDevice.getNamespaceId(), fakeDevice.getInstanceId());
    }

    private EddystoneUID(String namespace, String instanceId) {
        this.namespace = namespace;
        this.instanceId = instanceId;
    }

    private EddystoneUID(Parcel source) {
        Bundle bundle = source.readBundle(this.getClass().getClassLoader());
        this.namespace = bundle.getString(NAMESPACE);
        this.instanceId = bundle.getString(INSTANCE_ID);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public int describeContents() {
        return 0;
    }

    public String toString() {
        return this.namespace + ":" + this.instanceId;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putString(NAMESPACE, this.namespace);
        bundle.putString(INSTANCE_ID, this.instanceId);
        dest.writeBundle(bundle);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof EddystoneUID)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        EddystoneUID eddystoneUID = (EddystoneUID)o;
        return SDKEqualsBuilder.start().equals(this.namespace, eddystoneUID.namespace).equals(this.instanceId, eddystoneUID.instanceId).result();
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = HashCodeBuilder.init().append(this.namespace).append(this.instanceId).build();
        }
        return this.hashCode;
    }

    public static EddystoneUID fromQueriedBy(String queriedBy) {
        if (queriedBy == null) {
            throw new NullPointerException("queriedBy is null");
        }
        String[] split = queriedBy.split(":");
        if (split.length != 2) {
            throw new IllegalArgumentException("queriedBy is not valid format");
        }
        String namespace = split[0];
        String instanceId = split[1];
        return new EddystoneUID(namespace, instanceId);
    }

    public static EddystoneUID fromJSONObject(JSONObject jsonObject) {
        String namespace = JSONUtils.getStringOrNull(jsonObject, NAMESPACE);
        if (namespace == null) {
            throw new IllegalStateException("namespace is not present in the response");
        }
        String instanceId = JSONUtils.getStringOrNull(jsonObject, INSTANCE_ID);
        if (instanceId == null) {
            throw new IllegalStateException("instance id is not present in the response");
        }
        return new EddystoneUID(namespace, instanceId);
    }

    public static List<EddystoneUID> getEddystoneFutureIds(JSONObject jsonObject) {
        ArrayList<EddystoneUID> eddystoneUIDs = new ArrayList<EddystoneUID>();
        try {
            JSONObject futureShufflesObject = jsonObject.getJSONObject(FUTURE_SHUFFLES);
            JSONArray eddystoneFutureShuffles = futureShufflesObject.getJSONArray(EDDYSTONE);
            for (int i = 0; i < eddystoneFutureShuffles.length(); ++i) {
                JSONObject eddystoneFutureShufflesJSONObject = eddystoneFutureShuffles.getJSONObject(i);
                eddystoneUIDs.add(EddystoneUID.fromJSONObject(eddystoneFutureShufflesJSONObject));
            }
        }
        catch (JSONException e) {
            throw new IllegalStateException("futureIds is not present in the response");
        }
        return eddystoneUIDs;
    }
}

