/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.EddystoneUID;
import com.kontakt.sdk.android.common.model.IFutureId;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.JSONUtils;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class EddystoneFutureUID
implements IFutureId<EddystoneUID> {
    public static final Parcelable.Creator<EddystoneFutureUID> CREATOR = new Parcelable.Creator<EddystoneFutureUID>(){

        public EddystoneFutureUID createFromParcel(Parcel source) {
            return new EddystoneFutureUID(source);
        }

        public EddystoneFutureUID[] newArray(int size) {
            return new EddystoneFutureUID[size];
        }
    };
    private String uniqueId;
    private EddystoneUID queriedBy;
    private EddystoneUID resolved;
    private List<EddystoneUID> futureIds;

    public EddystoneFutureUID() {
    }

    private EddystoneFutureUID(Parcel source) {
        Bundle bundle = source.readBundle(this.getClass().getClassLoader());
        this.queriedBy = (EddystoneUID)bundle.getParcelable("queriedBy");
        this.resolved = (EddystoneUID)bundle.getParcelable("resolved");
        this.futureIds = bundle.getParcelableArrayList("futureId");
        this.uniqueId = bundle.getString("uniqueId");
    }

    @Override
    public EddystoneUID getQueriedBy() {
        return this.queriedBy;
    }

    public void setQueriedBy(EddystoneUID queriedBy) {
        this.queriedBy = queriedBy;
    }

    @Override
    public EddystoneUID getResolved() {
        return this.resolved;
    }

    public void setResolved(EddystoneUID resolved) {
        this.resolved = resolved;
    }

    @Override
    public List<EddystoneUID> getFutureIds() {
        return this.futureIds;
    }

    public void setFutureIds(List<EddystoneUID> futureUIDs) {
        this.futureIds = futureUIDs;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof EddystoneFutureUID)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        EddystoneFutureUID other = (EddystoneFutureUID)o;
        return SDKEqualsBuilder.start().equals(this.resolved, other.resolved).equals(this.queriedBy, other.queriedBy).equals(this.futureIds, other.futureIds).equals(this.uniqueId, other.uniqueId).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.resolved).append(this.queriedBy).append(this.futureIds).append(this.uniqueId).build();
    }

    public static EddystoneFutureUID from(JSONObject jsonObject) {
        String uniqueId = JSONUtils.getStringOrNull(jsonObject, "uniqueId");
        String queriedBy = JSONUtils.getStringOrNull(jsonObject, "queriedBy");
        EddystoneUID queriedByBeaconId = EddystoneUID.fromQueriedBy(queriedBy);
        EddystoneUID resolvedBeaconId = EddystoneUID.fromJSONObject(jsonObject);
        List<EddystoneUID> futureEddystoneUIDs = EddystoneUID.getEddystoneFutureIds(jsonObject);
        EddystoneFutureUID eddystoneFutureUID = new EddystoneFutureUID();
        eddystoneFutureUID.setUniqueId(uniqueId);
        eddystoneFutureUID.setQueriedBy(queriedByBeaconId);
        eddystoneFutureUID.setResolved(resolvedBeaconId);
        eddystoneFutureUID.setFutureIds(futureEddystoneUIDs);
        return eddystoneFutureUID;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putString("uniqueId", this.uniqueId);
        bundle.putParcelable("queriedBy", (Parcelable)this.queriedBy);
        bundle.putParcelable("resolved", (Parcelable)this.resolved);
        bundle.putParcelableArrayList("futureId", (ArrayList)this.futureIds);
        dest.writeBundle(bundle);
    }

    public int describeContents() {
        return 0;
    }
}

