/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.AbstractModel;
import com.kontakt.sdk.android.common.model.ICredentials;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;

public class DeviceCredentials
extends AbstractModel
implements ICredentials {
    private final String deviceUniqueId;
    private final String password;
    private final String masterPassword;
    private final int hashCode;
    public static final Parcelable.Creator<DeviceCredentials> CREATOR = new Parcelable.Creator<DeviceCredentials>(){

        public DeviceCredentials createFromParcel(Parcel source) {
            Bundle bundle = source.readBundle(this.getClass().getClassLoader());
            return new Builder().setDatabaseId(bundle.getInt("databaseId")).setDeviceUniqueId(bundle.getString("uniqueId")).setPassword(bundle.getString("password")).setMasterPassword(bundle.getString("masterPassword")).build();
        }

        public DeviceCredentials[] newArray(int size) {
            return new DeviceCredentials[size];
        }
    };

    private DeviceCredentials(Builder builder) {
        super(builder.databaseId);
        this.deviceUniqueId = builder.deviceUniqueId;
        this.password = builder.password;
        this.masterPassword = builder.masterPassword;
        this.hashCode = HashCodeBuilder.init().append(this.deviceUniqueId).append(this.password).append(this.masterPassword).build();
    }

    @Override
    public String getDeviceUniqueId() {
        return this.deviceUniqueId;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getMasterPassword() {
        return this.masterPassword;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DeviceCredentials)) {
            return false;
        }
        DeviceCredentials credentials = (DeviceCredentials)obj;
        return SDKEqualsBuilder.start().equals(this.deviceUniqueId, credentials.deviceUniqueId).equals(this.password, credentials.password).equals(this.masterPassword, credentials.masterPassword).result();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putString("uniqueId", this.deviceUniqueId);
        bundle.putString("password", this.password);
        bundle.putString("masterPassword", this.masterPassword);
        bundle.putInt("databaseId", this.databaseId);
        dest.writeBundle(bundle);
    }

    public static class Builder {
        private String deviceUniqueId;
        private String password;
        private String masterPassword;
        private int databaseId;

        public Builder setDeviceUniqueId(String deviceUniqueId) {
            this.deviceUniqueId = deviceUniqueId;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setMasterPassword(String masterPassword) {
            this.masterPassword = masterPassword;
            return this;
        }

        public Builder setDatabaseId(int databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public DeviceCredentials build() {
            return new DeviceCredentials(this);
        }
    }
}

