/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Bundle;
import android.os.Parcel;
import com.kontakt.sdk.android.common.model.AbstractModel;
import com.kontakt.sdk.android.common.model.Access;
import com.kontakt.sdk.android.common.model.Beacon;
import com.kontakt.sdk.android.common.model.CloudBeacon;
import com.kontakt.sdk.android.common.model.DeviceType;
import com.kontakt.sdk.android.common.model.IDevice;
import com.kontakt.sdk.android.common.model.IVenue;
import com.kontakt.sdk.android.common.model.Model;
import com.kontakt.sdk.android.common.model.Specification;
import com.kontakt.sdk.android.common.model.Venue;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class Device
extends AbstractModel
implements IDevice {
    private final String firmwareVersion;
    private final int interval;
    private final String alias;
    private final int txPower;
    private final String instanceId;
    private final String latitude;
    private final String longitude;
    private final Access access;
    private final IVenue venue;
    private final String url;
    private final String uniqueId;
    private final String namespace;
    private final int actionsCount;
    private final UUID id;
    private final DeviceType deviceType;
    private final UUID managerId;
    private final String name;
    private final Specification specification;
    private final Model model;
    private final List<DeviceProfile> deviceProfiles;
    private final UUID proximityUUID;
    private final int major;
    private final int minor;
    private final String macAddress;
    private final int hashCode;

    protected abstract void parcelProperties(Bundle var1);

    protected Device(Bundle bundle, Parcel parcel) {
        super(bundle.getInt("databaseId"));
        this.firmwareVersion = bundle.getString("firmware");
        this.interval = bundle.getInt("interval");
        this.alias = bundle.getString("alias");
        this.txPower = bundle.getInt("txPower");
        this.instanceId = bundle.getString("instanceId");
        this.latitude = bundle.getString("lat");
        this.longitude = bundle.getString("lng");
        this.access = (Access)((Object)bundle.getSerializable("access"));
        this.url = bundle.getString("url");
        this.uniqueId = bundle.getString("uniqueId");
        this.namespace = bundle.getString("namespaceId");
        this.actionsCount = bundle.getInt("actionsCount");
        this.id = (UUID)bundle.getSerializable("id");
        this.deviceType = (DeviceType)((Object)bundle.getSerializable("deviceType"));
        this.managerId = (UUID)bundle.getSerializable("managerId");
        this.name = bundle.getString("name");
        this.specification = (Specification)((Object)bundle.getSerializable("specification"));
        this.model = (Model)((Object)bundle.getSerializable("model"));
        this.proximityUUID = (UUID)bundle.getSerializable("proximity");
        this.major = bundle.getInt("major");
        this.minor = bundle.getInt("minor");
        this.macAddress = bundle.getString("mac");
        List<DeviceProfile> deviceProfileList = DeviceProfile.readFromParcel(parcel);
        this.deviceProfiles = Collections.unmodifiableList(deviceProfileList);
        this.venue = bundle.getBoolean("parcelable_has_venue") ? (Venue)Venue.CREATOR.createFromParcel(parcel) : null;
        this.hashCode = this.calculateHashCode();
    }

    protected Device(Builder builder) {
        super(builder.databaseId);
        this.firmwareVersion = builder.firmwareVersion;
        this.instanceId = builder.instanceId;
        this.alias = builder.alias;
        this.interval = builder.interval;
        this.txPower = builder.txPower;
        this.latitude = builder.latitude;
        this.longitude = builder.longitude;
        this.access = builder.access;
        this.venue = builder.venue;
        this.url = builder.url;
        this.uniqueId = builder.uniqueId;
        this.namespace = builder.namespace;
        this.actionsCount = builder.actionsCount;
        this.id = builder.id;
        this.deviceType = builder.deviceType;
        this.managerId = builder.managerId;
        this.name = builder.name;
        this.specification = builder.specification;
        this.model = builder.model;
        this.deviceProfiles = Collections.unmodifiableList(builder.deviceProfiles);
        this.proximityUUID = builder.proximityUUID;
        this.major = builder.major;
        this.minor = builder.minor;
        this.macAddress = builder.macAddress;
        this.hashCode = this.calculateHashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof Device)) {
            return false;
        }
        Device device = (Device)o;
        return SDKEqualsBuilder.start().equals(this.uniqueId, device.getUniqueId()).equals(this.firmwareVersion, device.getFirmwareVersion()).equals(this.instanceId, device.getInstanceId()).equals(this.alias, device.getAlias()).equals(this.interval, device.getInterval()).equals(this.txPower, device.getTxPower()).equals(this.latitude, device.getLatitude()).equals(this.longitude, device.getLongitude()).equals((Object)this.access, (Object)device.getAccess()).equals(this.venue, device.getVenue()).equals(this.url, device.getUrl()).equals(this.namespace, device.getNamespace()).equals(this.actionsCount, device.getActionsCount()).equals(this.id, device.getId()).equals((Object)this.deviceType, (Object)device.getDeviceType()).equals(this.managerId, device.getManagerId()).equals(this.name, device.getName()).equals((Object)this.specification, (Object)device.getSpecification()).equals((Object)this.model, (Object)device.getModel()).equals(this.deviceProfiles, device.getDeviceProfiles()).equals(this.proximityUUID, device.getProximityUUID()).equals(this.major, device.getMajor()).equals(this.minor, device.getMinor()).equals(this.macAddress, device.getMacAddress()).result();
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public UUID getProximityUUID() {
        return this.proximityUUID;
    }

    @Override
    public String getMacAddress() {
        return this.macAddress;
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public int getInterval() {
        return this.interval;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public int getTxPower() {
        return this.txPower;
    }

    @Override
    public IVenue getVenue() {
        return this.venue;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    @Override
    public UUID getManagerId() {
        return this.managerId;
    }

    @Override
    public int getActionsCount() {
        return this.actionsCount;
    }

    @Override
    public String getLatitude() {
        return this.latitude;
    }

    @Override
    public String getLongitude() {
        return this.longitude;
    }

    @Override
    public Access getAccess() {
        return this.access;
    }

    @Override
    public Specification getSpecification() {
        return this.specification;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public List<DeviceProfile> getDeviceProfiles() {
        return this.deviceProfiles;
    }

    @Override
    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putInt("databaseId", this.getDatabaseId());
        bundle.putString("firmware", this.getFirmwareVersion());
        bundle.putInt("interval", this.getInterval());
        bundle.putString("alias", this.getAlias());
        bundle.putInt("txPower", this.getTxPower());
        bundle.putString("instanceId", this.getInstanceId());
        bundle.putString("lat", this.getLatitude());
        bundle.putString("lng", this.getLongitude());
        bundle.putSerializable("access", (Serializable)((Object)this.getAccess()));
        bundle.putString("url", this.getUrl());
        bundle.putString("uniqueId", this.getUniqueId());
        bundle.putString("namespaceId", this.getNamespace());
        bundle.putInt("actionsCount", this.getActionsCount());
        bundle.putSerializable("id", (Serializable)this.getId());
        bundle.putSerializable("deviceType", (Serializable)((Object)this.getDeviceType()));
        bundle.putSerializable("managerId", (Serializable)this.getManagerId());
        bundle.putString("name", this.getName());
        bundle.putSerializable("specification", (Serializable)((Object)this.getSpecification()));
        bundle.putSerializable("model", (Serializable)((Object)this.getModel()));
        bundle.putInt("major", this.getMajor());
        bundle.putInt("minor", this.getMinor());
        bundle.putString("mac", this.getMacAddress());
        bundle.putSerializable("proximity", (Serializable)this.getProximityUUID());
        IVenue venue = this.getVenue();
        boolean shouldParcelVenue = flags != 1 && venue != null;
        bundle.putBoolean("parcelable_has_venue", shouldParcelVenue);
        this.parcelProperties(bundle);
        dest.writeBundle(bundle);
        List<DeviceProfile> deviceProfiles = this.getDeviceProfiles();
        DeviceProfile.writeToParcel(dest, deviceProfiles);
        if (shouldParcelVenue) {
            venue.writeToParcel(dest, 2);
        }
    }

    protected int calculateHashCode() {
        return HashCodeBuilder.init().append(this.uniqueId).append(this.firmwareVersion).append(this.instanceId).append(this.alias).append(this.interval).append(this.txPower).append(this.latitude).append(this.longitude).append((Object)this.access).append(this.venue).append(this.url).append(this.namespace).append(this.actionsCount).append(this.id).append((Object)this.deviceType).append(this.managerId).append(this.name).append((Object)this.specification).append((Object)this.model).append(this.deviceProfiles).append(this.proximityUUID).append(this.major).append(this.minor).append(this.macAddress).build();
    }

    public static Device from(JSONObject jsonObject) {
        try {
            DeviceType deviceType = DeviceType.valueOf(jsonObject.getString("deviceType"));
            switch (deviceType) {
                case BEACON: {
                    return Beacon.from(jsonObject);
                }
                case CLOUD_BEACON: {
                    return CloudBeacon.from(jsonObject);
                }
            }
            throw new IllegalStateException("Unknown device type: " + deviceType.name());
        }
        catch (Exception e) {
            throw new IllegalStateException("No device type found");
        }
    }

    public static List<IDevice> fromList(JSONObject jsonObject) {
        try {
            ArrayList<IDevice> devices = new ArrayList<IDevice>();
            JSONArray jsonArray = jsonObject.getJSONArray("devices");
            for (int i = 0; i < jsonArray.length(); ++i) {
                devices.add(Device.from(jsonArray.getJSONObject(i)));
            }
            return devices;
        }
        catch (Exception e) {
            throw new IllegalStateException("No devices found");
        }
    }

    public static abstract class Builder<T extends Device, B extends Builder<T, B>> {
        int databaseId = -1;
        String firmwareVersion;
        int interval;
        String alias;
        int txPower;
        String instanceId;
        String latitude;
        String longitude;
        Access access;
        IVenue venue;
        String url;
        String uniqueId;
        String namespace;
        int actionsCount;
        UUID id;
        DeviceType deviceType;
        UUID managerId;
        String name;
        Specification specification;
        Model model;
        UUID proximityUUID;
        int major;
        int minor;
        String macAddress;
        List<DeviceProfile> deviceProfiles = new ArrayList<DeviceProfile>();

        public Builder<T, B> setDatabaseId(int databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder<T, B> setFirmwareVersion(String firmwareVersion) {
            this.firmwareVersion = firmwareVersion;
            return this;
        }

        public Builder<T, B> setProximityUUID(UUID proximity) {
            this.proximityUUID = proximity;
            return this;
        }

        public Builder<T, B> setInterval(int interval) {
            this.interval = interval;
            return this;
        }

        public Builder<T, B> setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder<T, B> setTxPower(int txPower) {
            this.txPower = txPower;
            return this;
        }

        public Builder<T, B> setInstanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder<T, B> setLatitude(String latitude) {
            this.latitude = latitude;
            return this;
        }

        public Builder<T, B> setLongitude(String longitude) {
            this.longitude = longitude;
            return this;
        }

        public Builder<T, B> setAccess(Access access) {
            this.access = access;
            return this;
        }

        public Builder<T, B> setVenue(IVenue venue) {
            this.venue = venue;
            return this;
        }

        public Builder<T, B> setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder<T, B> setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public Builder<T, B> setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder<T, B> setActionsCount(int actionsCount) {
            this.actionsCount = actionsCount;
            return this;
        }

        public Builder<T, B> setId(UUID id) {
            this.id = id;
            return this;
        }

        public Builder<T, B> setDeviceType(DeviceType deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public Builder<T, B> setManagerId(UUID managerId) {
            this.managerId = managerId;
            return this;
        }

        public Builder<T, B> setName(String name) {
            this.name = name;
            return this;
        }

        public Builder<T, B> setSpecification(Specification specification) {
            this.specification = specification;
            return this;
        }

        public Builder<T, B> setModel(Model model) {
            this.model = model;
            return this;
        }

        public Builder<T, B> addDeviceProfiles(Collection<DeviceProfile> deviceProfiles) {
            this.deviceProfiles.addAll(deviceProfiles);
            return this;
        }

        public Builder<T, B> setMajor(int major) {
            this.major = major;
            return this;
        }

        public Builder<T, B> setMinor(int minor) {
            this.minor = minor;
            return this;
        }

        public Builder<T, B> setMacAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public abstract T build();
    }
}

