/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.model.AbstractModel;
import com.kontakt.sdk.android.common.model.ICounters;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.JSONUtils;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import org.json.JSONException;
import org.json.JSONObject;

public class Counters
extends AbstractModel
implements ICounters {
    public static final Parcelable.Creator<Counters> CREATOR = new Parcelable.Creator<Counters>(){

        public Counters createFromParcel(Parcel source) {
            Bundle bundle = source.readBundle();
            return new Builder().setDatabaseId(bundle.getInt("databaseId")).setPrivateDevicesCount(bundle.getInt("private")).setPublicDevicesCount(bundle.getInt("public")).setSharedDevicesCount(bundle.getInt("shared")).setSharedWithMeDevicesCount(bundle.getInt("sharedWithMe")).setPrivateVenuesCount(bundle.getInt("privatevenue")).setPublicVenuesCount(bundle.getInt("publicvenue")).setSharedVenuesCount(bundle.getInt("sharedvenue")).setSharedWithMeVenuesCount(bundle.getInt("sharedWithMevenue")).build();
        }

        public Counters[] newArray(int size) {
            return new Counters[size];
        }
    };
    private final int privateDevicesCount;
    private final int publicDevicesCount;
    private final int sharedDevicesCount;
    private final int sharedWithMeDevicesCount;
    private final int privateVenuesCount;
    private final int publicVenuesCount;
    private final int sharedVenuesCount;
    private final int sharedWithMeVenuesCount;
    private final int hashCode;

    private Counters(Builder builder) {
        super(builder.databaseId);
        this.privateDevicesCount = builder.privateDevicesCount;
        this.publicDevicesCount = builder.publicDevicesCount;
        this.sharedDevicesCount = builder.sharedDevicesCount;
        this.sharedWithMeDevicesCount = builder.sharedWithMeDevicesCount;
        this.privateVenuesCount = builder.privateVenuesCount;
        this.publicVenuesCount = builder.publicVenuesCount;
        this.sharedVenuesCount = builder.sharedVenuesCount;
        this.sharedWithMeVenuesCount = builder.sharedWithMeVenuesCount;
        this.hashCode = HashCodeBuilder.init().append(this.privateDevicesCount).append(this.publicDevicesCount).append(this.sharedDevicesCount).append(this.sharedWithMeDevicesCount).append(this.privateVenuesCount).append(this.publicVenuesCount).append(this.sharedVenuesCount).append(this.sharedWithMeVenuesCount).build();
    }

    @Override
    public int getPrivateDevicesCount() {
        return this.privateDevicesCount;
    }

    @Override
    public int getPublicDevicesCount() {
        return this.publicDevicesCount;
    }

    @Override
    public int getSharedDevicesCount() {
        return this.sharedDevicesCount;
    }

    @Override
    public int getSharedWithMeDevicesCount() {
        return this.sharedWithMeDevicesCount;
    }

    @Override
    public int getPrivateVenuesCount() {
        return this.privateVenuesCount;
    }

    @Override
    public int getPublicVenuesCount() {
        return this.publicVenuesCount;
    }

    @Override
    public int getSharedVenuesCount() {
        return this.sharedDevicesCount;
    }

    @Override
    public int getSharedWithMeVenuesCount() {
        return this.sharedWithMeVenuesCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof Counters)) {
            return false;
        }
        Counters counters = (Counters)o;
        return SDKEqualsBuilder.start().equals(this.privateDevicesCount, counters.privateDevicesCount).equals(this.publicDevicesCount, counters.publicDevicesCount).equals(this.sharedDevicesCount, counters.sharedDevicesCount).equals(this.sharedWithMeDevicesCount, counters.sharedWithMeDevicesCount).equals(this.privateVenuesCount, counters.privateVenuesCount).equals(this.publicVenuesCount, counters.publicVenuesCount).equals(this.sharedVenuesCount, counters.sharedVenuesCount).equals(this.sharedWithMeVenuesCount, counters.sharedWithMeVenuesCount).result();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle();
        bundle.putInt("databaseId", this.databaseId);
        bundle.putInt("private", this.privateDevicesCount);
        bundle.putInt("public", this.publicDevicesCount);
        bundle.putInt("shared", this.sharedDevicesCount);
        bundle.putInt("sharedWithMe", this.sharedWithMeDevicesCount);
        bundle.putInt("privatevenue", this.privateVenuesCount);
        bundle.putInt("publicvenue", this.publicVenuesCount);
        bundle.putInt("sharedvenue", this.sharedVenuesCount);
        bundle.putInt("sharedWithMevenue", this.sharedWithMeVenuesCount);
        dest.writeBundle(bundle);
    }

    public static ICounters from(JSONObject jsonObject) {
        try {
            JSONObject devicesJson = jsonObject.getJSONObject("devices");
            JSONObject venuesJson = jsonObject.getJSONObject("venues");
            return new Builder().setPrivateDevicesCount(JSONUtils.getInt(devicesJson, "private", 0)).setPublicDevicesCount(JSONUtils.getInt(devicesJson, "public", 0)).setSharedDevicesCount(JSONUtils.getInt(devicesJson, "shared", 0)).setSharedWithMeDevicesCount(JSONUtils.getInt(devicesJson, "sharedWithMe", 0)).setPrivateVenuesCount(JSONUtils.getInt(venuesJson, "private", 0)).setPublicVenuesCount(JSONUtils.getInt(venuesJson, "public", 0)).setSharedDevicesCount(JSONUtils.getInt(venuesJson, "shared", 0)).setSharedWithMeVenuesCount(JSONUtils.getInt(venuesJson, "sharedWithMe", 0)).build();
        }
        catch (JSONException e) {
            Logger.e("Could not create counter", e);
            return null;
        }
    }

    public static final class Builder {
        private int databaseId;
        private int privateDevicesCount;
        private int publicDevicesCount;
        private int sharedDevicesCount;
        private int sharedWithMeDevicesCount;
        private int privateVenuesCount;
        private int publicVenuesCount;
        private int sharedVenuesCount;
        private int sharedWithMeVenuesCount;

        public Builder setDatabaseId(int databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder setPrivateDevicesCount(int privateDevicesCount) {
            this.privateDevicesCount = privateDevicesCount;
            return this;
        }

        public Builder setPublicDevicesCount(int publicDevicesCount) {
            this.publicDevicesCount = publicDevicesCount;
            return this;
        }

        public Builder setSharedDevicesCount(int sharedDevicesCount) {
            this.sharedDevicesCount = sharedDevicesCount;
            return this;
        }

        public Builder setSharedWithMeDevicesCount(int sharedWithMeDevicesCount) {
            this.sharedWithMeDevicesCount = sharedWithMeDevicesCount;
            return this;
        }

        public Builder setPrivateVenuesCount(int privateVenuesCount) {
            this.privateVenuesCount = privateVenuesCount;
            return this;
        }

        public Builder setPublicVenuesCount(int publicVenuesCount) {
            this.publicVenuesCount = publicVenuesCount;
            return this;
        }

        public Builder setSharedVenuesCount(int sharedVenuesCount) {
            this.sharedVenuesCount = sharedVenuesCount;
            return this;
        }

        public Builder setSharedWithMeVenuesCount(int sharedWithMeVenuesCount) {
            this.sharedWithMeVenuesCount = sharedWithMeVenuesCount;
            return this;
        }

        public Counters build() {
            return new Counters(this);
        }
    }
}

