/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.model.AbstractModel;
import com.kontakt.sdk.android.common.model.Beacon;
import com.kontakt.sdk.android.common.model.IAction;
import com.kontakt.sdk.android.common.model.IContentAction;
import com.kontakt.sdk.android.common.model.IDevice;
import com.kontakt.sdk.android.common.util.ContentCategory;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.JSONUtils;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import java.io.Serializable;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class ContentAction
extends AbstractModel
implements IContentAction {
    private final UUID id;
    private final Proximity proximity;
    private final IDevice device;
    private final int contentLength;
    private final String contentType;
    private final String contentUrl;
    private final ContentCategory contentCategory;
    private final int hashCode;
    public static final Parcelable.Creator<ContentAction> CREATOR = new Parcelable.Creator<ContentAction>(){

        public ContentAction createFromParcel(Parcel input) {
            Builder builder = new Builder();
            Bundle bundle = input.readBundle(this.getClass().getClassLoader());
            if (bundle.getBoolean("parcelable_has_beacon")) {
                builder.setDevice((IDevice)Beacon.CREATOR.createFromParcel(input));
            }
            return builder.setId((UUID)bundle.getSerializable("id")).setProximity((Proximity)((Object)bundle.getSerializable("proximity"))).setContentLength(bundle.getInt("contentLength")).setContentType(bundle.getString("contentType")).setContentUrl(bundle.getString("content")).setContentCategory((ContentCategory)((Object)bundle.getSerializable("contentCategory"))).setDatabaseId(bundle.getInt("databaseId")).build();
        }

        public ContentAction[] newArray(int size) {
            return new ContentAction[size];
        }
    };

    private ContentAction(Builder builder) {
        super(builder.databaseId);
        this.id = builder.id;
        this.proximity = builder.proximity;
        this.device = builder.device;
        this.contentLength = builder.contentLength;
        this.contentType = builder.contentType;
        this.contentUrl = builder.contentUrl;
        this.contentCategory = builder.contentCategory;
        this.hashCode = HashCodeBuilder.init().append(this.id).append((Object)this.proximity).append(this.device).append(this.contentLength).append(this.contentType).append(this.contentUrl).append((Object)this.contentCategory).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof ContentAction)) {
            return false;
        }
        ContentAction contentAction = (ContentAction)o;
        return SDKEqualsBuilder.start().equals(this.id, contentAction.id).equals((Object)this.proximity, (Object)contentAction.proximity).equals(this.device, contentAction.device).equals(this.contentLength, contentAction.contentLength).equals(this.contentType, contentAction.contentType).equals(this.contentUrl, contentAction.contentUrl).equals((Object)this.contentCategory, (Object)contentAction.contentCategory).result();
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public Proximity getProximity() {
        return this.proximity;
    }

    @Override
    public IAction.ActionType getType() {
        return IAction.ActionType.CONTENT;
    }

    @Override
    public IDevice getDevice() {
        return this.device;
    }

    @Override
    public int getContentLength() {
        return this.contentLength;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getContentUrl() {
        return this.contentUrl;
    }

    @Override
    public ContentCategory getContentCategory() {
        return this.contentCategory;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putSerializable("id", (Serializable)this.id);
        bundle.putSerializable("proximity", (Serializable)((Object)this.proximity));
        bundle.putParcelable("device", (Parcelable)this.device);
        bundle.putInt("contentLength", this.contentLength);
        bundle.putString("contentType", this.contentType);
        bundle.putString("content", this.contentUrl);
        bundle.putSerializable("contentCategory", (Serializable)((Object)this.contentCategory));
        boolean shouldParcelBeacon = flags != 2 && this.device != null;
        bundle.putBoolean("parcelable_has_beacon", shouldParcelBeacon);
        dest.writeBundle(bundle);
        if (shouldParcelBeacon) {
            this.device.writeToParcel(dest, 4);
        }
    }

    public static ContentAction from(JSONObject jsonObject) {
        try {
            return new Builder().setId(JSONUtils.getUUIDOrNull(jsonObject, "id")).setDevice(JSONUtils.hasJSONKey(jsonObject, "device") ? Beacon.from(jsonObject.getJSONObject("device")) : null).setProximity(Proximity.valueOf(jsonObject.getString("proximity"))).setContentLength(JSONUtils.getInt(jsonObject, "contentLength", 0)).setContentType(JSONUtils.getStringOrNull(jsonObject, "contentType")).setContentUrl(JSONUtils.getStringOrNull(jsonObject, "content")).setContentCategory(JSONUtils.hasJSONKey(jsonObject, "contentCategory") ? ContentCategory.valueOf(jsonObject.getString("contentCategory")) : ContentCategory.UNKNOWN).build();
        }
        catch (JSONException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static class Builder {
        private int databaseId;
        private UUID id;
        private Proximity proximity;
        private IDevice device;
        private int contentLength;
        private String contentType;
        private String contentUrl;
        private ContentCategory contentCategory;

        public Builder setDatabaseId(int databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder setId(UUID id) {
            this.id = id;
            return this;
        }

        public Builder setProximity(Proximity proximity) {
            this.proximity = proximity;
            return this;
        }

        public Builder setDevice(IDevice device) {
            this.device = device;
            return this;
        }

        public Builder setContentLength(int contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public Builder setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder setContentUrl(String contentUrl) {
            this.contentUrl = contentUrl;
            return this;
        }

        public Builder setContentCategory(ContentCategory contentCategory) {
            this.contentCategory = contentCategory;
            return this;
        }

        public ContentAction build() {
            return new ContentAction(this);
        }
    }
}

