/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.AbstractModel;
import com.kontakt.sdk.android.common.model.IConfig;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.util.EddystoneUtils;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.JSONUtils;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Config
extends AbstractModel
implements IConfig,
Parcelable {
    private final UUID id;
    private final String uniqueId;
    private final UUID proximityUUID;
    private final int major;
    private final int minor;
    private final int txPower;
    private final int interval;
    private final int hashCode;
    private final String namespace;
    private final String url;
    private final String instanceId;
    private final List<DeviceProfile> deviceProfiles;
    private final Boolean shuffled;
    private final String name;
    private final String devicePassword;
    public static final Parcelable.Creator<Config> CREATOR = new Parcelable.Creator<Config>(){

        public Config createFromParcel(Parcel source) {
            Bundle bundle = source.readBundle(this.getClass().getClassLoader());
            List<DeviceProfile> deviceProfileList = DeviceProfile.readFromParcel(source);
            return new Builder().setId((UUID)bundle.getSerializable("id")).setDeviceUniqueId(bundle.getString("uniqueId")).setProximityUUID((UUID)bundle.getSerializable("proximity")).setMajor(bundle.getInt("major")).setMinor(bundle.getInt("minor")).setTxPower(bundle.getInt("txPower")).setInterval(bundle.getInt("interval")).setDatabaseId(bundle.getInt("databaseId")).setNamespace(bundle.getString("namespace")).setInstanceId(bundle.getString("instanceId")).setUrl(bundle.getString("url")).setDeviceProfiles(deviceProfileList).setShuffled(bundle.getBoolean("shuffled")).setName(bundle.getString("name")).setPassword(bundle.getString("password")).build();
        }

        public Config[] newArray(int size) {
            return new Config[size];
        }
    };

    Config(Builder builder) {
        super(builder.databaseId);
        this.id = builder.id;
        this.uniqueId = builder.uniqueId;
        this.proximityUUID = builder.proximityUUID;
        this.major = builder.major;
        this.minor = builder.minor;
        this.txPower = builder.txPower;
        this.interval = builder.interval;
        this.namespace = builder.namespace;
        this.url = builder.url;
        this.instanceId = builder.instanceId;
        this.deviceProfiles = builder.deviceProfiles;
        this.shuffled = builder.shuffled;
        this.name = builder.name;
        this.devicePassword = builder.devicePassword;
        this.hashCode = HashCodeBuilder.init().append(this.id).append(this.uniqueId).append(this.proximityUUID).append(this.major).append(this.minor).append(this.txPower).append(this.interval).append(this.namespace).append(this.url).append(this.instanceId).append(this.shuffled).append(this.name).append(this.devicePassword).build();
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public String getDeviceUniqueId() {
        return this.uniqueId;
    }

    @Override
    public UUID getProximityUUID() {
        return this.proximityUUID;
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public int getTxPower() {
        return this.txPower;
    }

    @Override
    public int getInterval() {
        return this.interval;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public List<DeviceProfile> getDeviceProfiles() {
        return this.deviceProfiles;
    }

    @Override
    public Boolean isShuffled() {
        return this.shuffled;
    }

    @Override
    public String getDeviceName() {
        return this.name;
    }

    @Override
    public String getDevicePassword() {
        return this.devicePassword;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Config)) {
            return false;
        }
        Config config = (Config)object;
        return SDKEqualsBuilder.start().equals(this.id, config.id).equals(this.uniqueId, config.uniqueId).equals(this.proximityUUID, config.proximityUUID).equals(this.major, config.major).equals(this.minor, config.minor).equals(this.txPower, config.txPower).equals(this.interval, config.interval).equals(this.namespace, config.namespace).equals(this.url, config.url).equals(this.instanceId, config.instanceId).equals(this.name, config.name).equals(this.devicePassword, config.devicePassword).result();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putSerializable("id", (Serializable)this.id);
        bundle.putString("uniqueId", this.uniqueId);
        bundle.putSerializable("proximity", (Serializable)this.proximityUUID);
        bundle.putInt("major", this.major);
        bundle.putInt("minor", this.minor);
        bundle.putInt("txPower", this.txPower);
        bundle.putInt("interval", this.interval);
        bundle.putInt("databaseId", this.databaseId);
        bundle.putString("namespace", this.getNamespace());
        bundle.putString("url", this.getUrl());
        bundle.putString("instanceId", this.getInstanceId());
        if (this.shuffled != null) {
            bundle.putBoolean("shuffled", this.shuffled.booleanValue());
        }
        bundle.putString("name", this.name);
        bundle.putString("password", this.devicePassword);
        dest.writeBundle(bundle);
        List<DeviceProfile> deviceProfiles = this.getDeviceProfiles();
        DeviceProfile.writeToParcel(dest, deviceProfiles);
    }

    public static Config from(JSONObject jsonObject) {
        try {
            String hexedUrl = JSONUtils.getStringOrNull(jsonObject, "url");
            Builder builder = new Builder().setId(JSONUtils.getUUIDOrNull(jsonObject, "id")).setDeviceUniqueId(JSONUtils.getStringOrNull(jsonObject, "uniqueId")).setProximityUUID(JSONUtils.getUUIDOrNull(jsonObject, "proximity")).setMajor(JSONUtils.getInt(jsonObject, "major", -1)).setMinor(JSONUtils.getInt(jsonObject, "minor", -1)).setTxPower(JSONUtils.getInt(jsonObject, "txPower", -1)).setInterval(JSONUtils.getInt(jsonObject, "interval", -1)).setNamespace(JSONUtils.getStringOrNull(jsonObject, "namespace")).setUrl(hexedUrl != null ? EddystoneUtils.fromHexedUrlToUrl(hexedUrl) : null).setInstanceId(JSONUtils.getStringOrNull(jsonObject, "instanceId")).setShuffled(JSONUtils.getBooleanBoxed(jsonObject, "shuffled")).setName(JSONUtils.getStringOrNull(jsonObject, "name")).setPassword(JSONUtils.getStringOrNull(jsonObject, "password"));
            JSONArray profiles = jsonObject.optJSONArray("profiles");
            if (profiles != null) {
                ArrayList<DeviceProfile> deviceProfileList = new ArrayList<DeviceProfile>();
                int profilesLength = profiles.length();
                for (int i = 0; i < profilesLength; ++i) {
                    deviceProfileList.add(DeviceProfile.valueOf((String)profiles.get(i)));
                }
                builder.setDeviceProfiles(deviceProfileList);
            }
            return builder.build();
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public static class Builder {
        int databaseId;
        private UUID id;
        private String uniqueId;
        private UUID proximityUUID;
        private int major = 0;
        private int minor = 0;
        private int txPower = -1;
        private int interval = 0;
        private String namespace;
        private String url;
        private String instanceId;
        private List<DeviceProfile> deviceProfiles = new ArrayList<DeviceProfile>();
        private Boolean shuffled;
        private String name;
        private String devicePassword;

        public Config build() {
            return new Config(this);
        }

        public Builder setDatabaseId(int databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder setDeviceUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public Builder setId(UUID id) {
            this.id = id;
            return this;
        }

        public Builder setProximityUUID(UUID proximity) {
            this.proximityUUID = proximity;
            return this;
        }

        public Builder setMajor(int major) {
            this.major = major;
            return this;
        }

        public Builder setMinor(int minor) {
            this.minor = minor;
            return this;
        }

        public Builder setTxPower(int txPower) {
            this.txPower = txPower;
            return this;
        }

        public Builder setInterval(int interval) {
            this.interval = interval;
            return this;
        }

        public Builder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setInstanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder setDeviceProfiles(Collection<DeviceProfile> deviceProfiles) {
            this.deviceProfiles.addAll(deviceProfiles);
            return this;
        }

        public Builder setShuffled(Boolean shuffled) {
            this.shuffled = shuffled;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setPassword(String devicePassword) {
            this.devicePassword = devicePassword;
            return this;
        }
    }
}

