/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.AbstractModel;
import com.kontakt.sdk.android.common.model.ICompany;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.JSONUtils;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import java.io.Serializable;
import java.util.UUID;
import org.json.JSONObject;

public class Company
extends AbstractModel
implements ICompany {
    private final UUID id;
    private final String countryCode;
    private final String name;
    private final String uniqueId;
    private final int hashCode;
    public static final Parcelable.Creator<Company> CREATOR = new Parcelable.Creator<Company>(){

        public Company createFromParcel(Parcel input) {
            Bundle bundle = input.readBundle(this.getClass().getClassLoader());
            return new Builder().setUniqueId(bundle.getString("uniqueId")).setId((UUID)bundle.getSerializable("id")).setCountryCode(bundle.getString("countryCode")).setName(bundle.getString("name")).setDatabaseId(bundle.getInt("databaseId")).build();
        }

        public Company[] newArray(int size) {
            return new Company[size];
        }
    };

    private Company(Builder builder) {
        super(builder.databaseId);
        this.id = builder.id;
        this.countryCode = builder.countryCode;
        this.name = builder.name;
        this.uniqueId = builder.uniqueId;
        this.hashCode = HashCodeBuilder.init().append(this.id).append(this.countryCode).append(this.name).append(this.uniqueId).build();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Company)) {
            return false;
        }
        Company company = (Company)obj;
        return SDKEqualsBuilder.start().equals(this.id, company.id).equals(this.countryCode, company.countryCode).equals(this.name, company.name).equals(this.uniqueId, company.uniqueId).result();
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public String getCountryCode() {
        return this.countryCode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    public static Company from(JSONObject jsonObject) {
        return new Builder().setId(JSONUtils.getUUIDOrNull(jsonObject, "id")).setCountryCode(JSONUtils.getStringOrNull(jsonObject, "countryCode")).setName(JSONUtils.getStringOrNull(jsonObject, "name")).setUniqueId(JSONUtils.getStringOrNull(jsonObject, "uniqueId")).build();
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putSerializable("id", (Serializable)this.id);
        bundle.putString("countryCode", this.countryCode);
        bundle.putString("name", this.name);
        bundle.putString("uniqueId", this.uniqueId);
        bundle.putInt("databaseId", this.databaseId);
        dest.writeBundle(bundle);
    }

    public static class Builder {
        private int databaseId;
        private UUID id;
        private String countryCode;
        private String name;
        private String uniqueId;

        public Builder setDatabaseId(int databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder setId(UUID id) {
            this.id = id;
            return this;
        }

        public Builder setCountryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public Company build() {
            return new Company(this);
        }
    }
}

