/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.AbstractModel;
import com.kontakt.sdk.android.common.model.Config;
import com.kontakt.sdk.android.common.model.ICloudBeacon;
import com.kontakt.sdk.android.common.model.ICloudConfig;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.JSONUtils;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public final class CloudConfig
extends AbstractModel
implements ICloudConfig {
    private final Config config;
    private final String defaultSSIDName;
    private final String defaultSSIDKey;
    private final String defaultSSIDAuth;
    private final String defaultSSIDCrypt;
    private final String password;
    private final String name;
    private final ICloudBeacon.WorkingMode workingMode;
    private final int wifiScanInterval;
    private final int dataSendInterval;
    private final int bleScanInterval;
    private final int bleScanDuration;
    private final int hashCode;
    public static final Parcelable.Creator<CloudConfig> CREATOR = new Parcelable.Creator<CloudConfig>(){

        public CloudConfig createFromParcel(Parcel source) {
            Bundle bundle = source.readBundle(this.getClass().getClassLoader());
            Config config = (Config)bundle.getParcelable("config");
            return new Builder().setDatabaseId(config.getDatabaseId()).setId(config.getId()).setBleScanDuration(bundle.getInt("bleScanDuration")).setBleScanInterval(bundle.getInt("bleScanInterval")).setDataSendInterval(bundle.getInt("dataSendInterval")).setDefaultSSIDAuth(bundle.getString("defaultSSIDAuth")).setDefaultSSIDCrypt(bundle.getString("defaultSSIDCrypt")).setDefaultSSIDKey(bundle.getString("defaultSSIDKey")).setDefaultSSIDName(bundle.getString("defaultSSIDName")).setWifiScanInterval(bundle.getInt("wifiScanInterval")).setProximityUUID(config.getProximityUUID()).setDeviceUniqueId(config.getDeviceUniqueId()).setInterval(config.getInterval()).setMajor(config.getMajor()).setMinor(config.getMinor()).setTxPower(config.getTxPower()).setDataSendInterval(bundle.getInt("dataSendInterval")).setPassword(bundle.getString("password")).setName(bundle.getString("name")).setWorkingMode((ICloudBeacon.WorkingMode)((Object)bundle.getSerializable("workingMode"))).build();
        }

        public CloudConfig[] newArray(int size) {
            return new CloudConfig[size];
        }
    };

    private CloudConfig(Builder builder) {
        super(builder.configBuilder.databaseId);
        this.config = new Config(builder.configBuilder);
        this.defaultSSIDName = builder.defaultSSIDName;
        this.defaultSSIDKey = builder.defaultSSIDKey;
        this.defaultSSIDAuth = builder.defaultSSIDAuth;
        this.defaultSSIDCrypt = builder.defaultSSIDCrypt;
        this.workingMode = builder.workingMode;
        this.wifiScanInterval = builder.wifiScanInterval;
        this.dataSendInterval = builder.dataSendInterval;
        this.bleScanInterval = builder.bleScanInterval;
        this.bleScanDuration = builder.bleScanDuration;
        this.password = builder.password;
        this.name = builder.name;
        this.hashCode = HashCodeBuilder.init().append(this.config.hashCode()).append(this.defaultSSIDName).append(this.defaultSSIDKey).append(this.defaultSSIDAuth).append(this.defaultSSIDCrypt).append((Object)this.workingMode).append(this.wifiScanInterval).append(this.dataSendInterval).append(this.bleScanInterval).append(this.bleScanDuration).append(this.password).append(this.name).build();
    }

    @Override
    public String getDefaultSSIDName() {
        return this.defaultSSIDName;
    }

    @Override
    public String getDefaultSSIDKey() {
        return this.defaultSSIDKey;
    }

    @Override
    public String getDefaultSSIDAuth() {
        return this.defaultSSIDAuth;
    }

    @Override
    public String getDefaultSSIDCrypt() {
        return this.defaultSSIDCrypt;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ICloudBeacon.WorkingMode getWorkingMode() {
        return this.workingMode;
    }

    @Override
    public int getWifiScanInterval() {
        return this.wifiScanInterval;
    }

    @Override
    public int getDataSendInterval() {
        return this.dataSendInterval;
    }

    @Override
    public int getBleScanInterval() {
        return this.bleScanInterval;
    }

    @Override
    public int getBleScanDuration() {
        return this.bleScanDuration;
    }

    @Override
    public UUID getId() {
        return this.config.getId();
    }

    @Override
    public String getDeviceUniqueId() {
        return this.config.getDeviceUniqueId();
    }

    @Override
    public UUID getProximityUUID() {
        return this.config.getProximityUUID();
    }

    @Override
    public int getMajor() {
        return this.config.getMajor();
    }

    @Override
    public int getMinor() {
        return this.config.getMinor();
    }

    @Override
    public int getTxPower() {
        return this.config.getTxPower();
    }

    @Override
    public int getInterval() {
        return this.config.getInterval();
    }

    @Override
    public String getNamespace() {
        return null;
    }

    @Override
    public String getUrl() {
        return null;
    }

    @Override
    public String getInstanceId() {
        return null;
    }

    @Override
    public List<DeviceProfile> getDeviceProfiles() {
        return null;
    }

    @Override
    public Boolean isShuffled() {
        return false;
    }

    @Override
    public String getDeviceName() {
        return null;
    }

    @Override
    public String getDevicePassword() {
        return null;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putParcelable("config", (Parcelable)this.config);
        bundle.putString("defaultSSIDName", this.defaultSSIDName);
        bundle.putString("defaultSSIDKey", this.defaultSSIDKey);
        bundle.putString("defaultSSIDAuth", this.defaultSSIDAuth);
        bundle.putString("defaultSSIDCrypt", this.defaultSSIDCrypt);
        bundle.putString("password", this.password);
        bundle.putString("name", this.name);
        bundle.putSerializable("workingMode", (Serializable)((Object)this.workingMode));
        bundle.putInt("wifiScanInterval", this.wifiScanInterval);
        bundle.putInt("dataSendInterval", this.dataSendInterval);
        bundle.putInt("bleScanDuration", this.bleScanDuration);
        bundle.putInt("bleScanInterval", this.bleScanInterval);
        dest.writeBundle(bundle);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof CloudConfig)) {
            return false;
        }
        CloudConfig cloudConfig = (CloudConfig)obj;
        return SDKEqualsBuilder.start().equals(cloudConfig.config, cloudConfig.config).equals(this.defaultSSIDName, cloudConfig.defaultSSIDName).equals(this.defaultSSIDKey, cloudConfig.defaultSSIDKey).equals(this.defaultSSIDAuth, cloudConfig.defaultSSIDAuth).equals(this.defaultSSIDCrypt, cloudConfig.defaultSSIDCrypt).equals((Object)this.workingMode, (Object)cloudConfig.workingMode).equals(this.wifiScanInterval, cloudConfig.wifiScanInterval).equals(this.dataSendInterval, cloudConfig.dataSendInterval).equals(this.bleScanInterval, cloudConfig.bleScanInterval).equals(this.bleScanDuration, cloudConfig.bleScanDuration).equals(this.password, cloudConfig.password).equals(this.name, cloudConfig.name).result();
    }

    public static CloudConfig from(JSONObject jsonObject) {
        try {
            return new Builder().setWifiScanInterval(JSONUtils.getInt(jsonObject, "wifiScanInterval", -1)).setBleScanDuration(JSONUtils.getInt(jsonObject, "bleScanDuration", -1)).setInterval(JSONUtils.getInt(jsonObject, "interval", -1)).setWorkingMode(JSONUtils.hasJSONKey(jsonObject, "workingMode") ? ICloudBeacon.WorkingMode.valueOf(jsonObject.getString("workingMode")) : null).setDefaultSSIDAuth(JSONUtils.getStringOrNull(jsonObject, "defaultSSIDAuth")).setMinor(JSONUtils.getInt(jsonObject, "minor", -1)).setTxPower(JSONUtils.getInt(jsonObject, "txPower", -1)).setPassword(JSONUtils.getStringOrNull(jsonObject, "password")).setDeviceUniqueId(JSONUtils.getStringOrNull(jsonObject, "uniqueId")).setDataSendInterval(JSONUtils.getInt(jsonObject, "dataSendInterval", -1)).setProximityUUID(UUID.fromString(JSONUtils.getStringOrNull(jsonObject, "proximity"))).setDefaultSSIDCrypt(JSONUtils.getStringOrNull(jsonObject, "defaultSSIDCrypt")).setBleScanInterval(JSONUtils.getInt(jsonObject, "bleScanInterval", -1)).setName(JSONUtils.getStringOrNull(jsonObject, "name")).setDefaultSSIDName(JSONUtils.getStringOrNull(jsonObject, "defaultSSIDName")).setMajor(JSONUtils.getInt(jsonObject, "major", -1)).build();
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    public static final class Builder {
        final Config.Builder configBuilder = new Config.Builder();
        private String defaultSSIDName;
        private String defaultSSIDKey;
        private String defaultSSIDAuth;
        private String defaultSSIDCrypt;
        private ICloudBeacon.WorkingMode workingMode;
        private int wifiScanInterval;
        private int dataSendInterval;
        private int bleScanInterval;
        private int bleScanDuration;
        private String password;
        private String name;

        public Builder setDatabaseId(int databaseId) {
            this.configBuilder.setDatabaseId(databaseId);
            return this;
        }

        public Builder setDeviceUniqueId(String uniqueId) {
            this.configBuilder.setDeviceUniqueId(uniqueId);
            return this;
        }

        public Builder setId(UUID id) {
            this.configBuilder.setId(id);
            return this;
        }

        public Builder setProximityUUID(UUID proximity) {
            this.configBuilder.setProximityUUID(proximity);
            return this;
        }

        public Builder setMajor(int major) {
            this.configBuilder.setMajor(major);
            return this;
        }

        public Builder setMinor(int minor) {
            this.configBuilder.setMinor(minor);
            return this;
        }

        public Builder setTxPower(int txPower) {
            this.configBuilder.setTxPower(txPower);
            return this;
        }

        public Builder setInterval(int interval) {
            this.configBuilder.setInterval(interval);
            return this;
        }

        public Builder setDefaultSSIDName(String defaultSSIDName) {
            this.defaultSSIDName = defaultSSIDName;
            return this;
        }

        public Builder setDefaultSSIDKey(String defaultSSIDKey) {
            this.defaultSSIDKey = defaultSSIDKey;
            return this;
        }

        public Builder setDefaultSSIDAuth(String defaultSSIDAuth) {
            this.defaultSSIDAuth = defaultSSIDAuth;
            return this;
        }

        public Builder setDefaultSSIDCrypt(String defaultSSIDCrypt) {
            this.defaultSSIDCrypt = defaultSSIDCrypt;
            return this;
        }

        public Builder setWorkingMode(ICloudBeacon.WorkingMode workingMode) {
            this.workingMode = workingMode;
            return this;
        }

        public Builder setWifiScanInterval(int wifiScanInterval) {
            this.wifiScanInterval = wifiScanInterval;
            return this;
        }

        public Builder setDataSendInterval(int dataSendInterval) {
            this.dataSendInterval = dataSendInterval;
            return this;
        }

        public Builder setBleScanInterval(int bleScanInterval) {
            this.bleScanInterval = bleScanInterval;
            return this;
        }

        public Builder setBleScanDuration(int bleScanDuration) {
            this.bleScanDuration = bleScanDuration;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public CloudConfig build() {
            return new CloudConfig(this);
        }
    }
}

