/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.Access;
import com.kontakt.sdk.android.common.model.Device;
import com.kontakt.sdk.android.common.model.DeviceType;
import com.kontakt.sdk.android.common.model.ICloudBeacon;
import com.kontakt.sdk.android.common.model.Venue;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.util.EddystoneUtils;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.JSONUtils;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CloudBeacon
extends Device
implements ICloudBeacon {
    private final int bleScanDuration;
    private final int bleScanInterval;
    private final int dataSendInterval;
    private final String defaultSSIDAuth;
    private final String defaultSSIDCrypt;
    private final String defaultSSIDName;
    private final ICloudBeacon.HashingPolicy hashingPolicy;
    private final String maintenanceEndTime;
    private final String maintenanceStartTime;
    private final int wifiScanInterval;
    private final ICloudBeacon.WorkingMode workingMode;
    private final int hashCode;
    public static final Parcelable.Creator<CloudBeacon> CREATOR = new Parcelable.Creator<CloudBeacon>(){

        public CloudBeacon createFromParcel(Parcel source) {
            Bundle bundle = source.readBundle(this.getClass().getClassLoader());
            return new CloudBeacon(bundle, source);
        }

        public CloudBeacon[] newArray(int size) {
            return new CloudBeacon[size];
        }
    };

    public CloudBeacon(Builder builder) {
        super(builder);
        this.wifiScanInterval = builder.wifiScanInterval;
        this.bleScanDuration = builder.bleScanDuration;
        this.workingMode = builder.workingMode;
        this.defaultSSIDAuth = builder.defaultSSIDAuth;
        this.maintenanceStartTime = builder.maintenanceStartTime;
        this.dataSendInterval = builder.dataSendInterval;
        this.defaultSSIDCrypt = builder.defaultSSIDCrypt;
        this.bleScanInterval = builder.bleScanInterval;
        this.defaultSSIDName = builder.defaultSSIDName;
        this.maintenanceEndTime = builder.maintenanceEndTime;
        this.hashingPolicy = builder.hashingPolicy;
        this.hashCode = this.calculateHashCode();
    }

    private CloudBeacon(Bundle bundle, Parcel parcel) {
        super(bundle, parcel);
        this.wifiScanInterval = bundle.getInt("wifiScanInterval");
        this.bleScanDuration = bundle.getInt("bleScanDuration");
        this.workingMode = (ICloudBeacon.WorkingMode)((Object)bundle.getSerializable("workingMode"));
        this.defaultSSIDAuth = bundle.getString("defaultSSIDAuth");
        this.maintenanceStartTime = bundle.getString("maintenanceStart");
        this.maintenanceEndTime = bundle.getString("maintenanceEnd");
        this.dataSendInterval = bundle.getInt("dataSendInterval");
        this.defaultSSIDCrypt = bundle.getString("defaultSSIDCrypt");
        this.bleScanInterval = bundle.getInt("bleScanInterval");
        this.defaultSSIDName = bundle.getString("defaultSSIDName");
        this.hashingPolicy = (ICloudBeacon.HashingPolicy)((Object)bundle.getSerializable("hashingPolicy"));
        this.hashCode = this.calculateHashCode();
    }

    @Override
    protected int calculateHashCode() {
        return HashCodeBuilder.init().append(super.hashCode()).append(this.wifiScanInterval).append(this.bleScanDuration).append((Object)this.workingMode).append(this.defaultSSIDAuth).append(this.maintenanceStartTime).append(this.dataSendInterval).append(this.defaultSSIDCrypt).append(this.bleScanInterval).append(this.defaultSSIDName).append(this.maintenanceEndTime).append((Object)this.hashingPolicy).build();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof CloudBeacon)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CloudBeacon cloudBeacon = (CloudBeacon)o;
        return SDKEqualsBuilder.start().equals(this.wifiScanInterval, cloudBeacon.wifiScanInterval).equals(this.bleScanDuration, cloudBeacon.bleScanDuration).equals((Object)this.workingMode, (Object)cloudBeacon.workingMode).equals(this.defaultSSIDAuth, cloudBeacon.defaultSSIDAuth).equals(this.maintenanceEndTime, cloudBeacon.maintenanceEndTime).equals(this.maintenanceStartTime, cloudBeacon.maintenanceStartTime).equals(this.dataSendInterval, cloudBeacon.dataSendInterval).equals(this.defaultSSIDCrypt, cloudBeacon.defaultSSIDCrypt).equals(this.bleScanInterval, cloudBeacon.bleScanInterval).equals(this.defaultSSIDName, cloudBeacon.defaultSSIDName).equals((Object)this.hashingPolicy, (Object)cloudBeacon.hashingPolicy).result();
    }

    public static CloudBeacon from(JSONObject jsonObject) {
        Access access = Access.valueOf(JSONUtils.getStringOrNull(jsonObject, "access"));
        String hexedUrl = JSONUtils.getStringOrNull(jsonObject, "url");
        DeviceType deviceType = DeviceType.valueOf(JSONUtils.getStringOrNull(jsonObject, "deviceType"));
        ICloudBeacon.HashingPolicy hashingPolicy = ICloudBeacon.HashingPolicy.valueOf(JSONUtils.getStringOrNull(jsonObject, "hashingPolicy"));
        try {
            JSONArray profiles = jsonObject.optJSONArray("profiles");
            Builder builder = new Builder();
            builder.setWifiScanInterval(JSONUtils.getInt(jsonObject, "wifiScanInterval", 0)).setBleScanDuration(JSONUtils.getInt(jsonObject, "bleScanDuration", 0)).setWorkingMode(ICloudBeacon.WorkingMode.valueOf(JSONUtils.getString(jsonObject, "workingMode", ICloudBeacon.WorkingMode.NONE.name()))).setDefaultSSIDAuth(JSONUtils.getStringOrNull(jsonObject, "defaultSSIDAuth")).setMaintenanceStart(JSONUtils.getStringOrNull(jsonObject, "maintenanceStart")).setMaintenanceEnd(JSONUtils.getStringOrNull(jsonObject, "maintenanceEnd")).setDataSendInterval(JSONUtils.getInt(jsonObject, "dataSendInterval", 0)).setDefaultSSIDName(JSONUtils.getStringOrNull(jsonObject, "defaultSSIDName")).setDefaultSSIDCrypt(JSONUtils.getStringOrNull(jsonObject, "defaultSSIDCrypt")).setBleScanInterval(JSONUtils.getInt(jsonObject, "bleScanInterval", 0)).setHashingPolicy(hashingPolicy).setId(JSONUtils.getUUIDOrNull(jsonObject, "id")).setProximityUUID(JSONUtils.getUUIDOrNull(jsonObject, "proximity")).setMajor(JSONUtils.getInt(jsonObject, "major", 0)).setMinor(JSONUtils.getInt(jsonObject, "minor", 0)).setMacAddress(JSONUtils.getString(jsonObject, "mac", "")).setTxPower(JSONUtils.getInt(jsonObject, "txPower", -1)).setName(JSONUtils.getStringOrNull(jsonObject, "name")).setAlias(JSONUtils.getStringOrNull(jsonObject, "alias")).setInterval(JSONUtils.getInt(jsonObject, "interval", 0)).setUniqueId(JSONUtils.getString(jsonObject, "uniqueId", "")).setActionsCount(JSONUtils.getInt(jsonObject, "actionsCount", 0)).setManagerId(JSONUtils.getUUIDOrNull(jsonObject, "managerId")).setVenue(JSONUtils.hasJSONKey(jsonObject, "venue") ? Venue.from(jsonObject.getJSONObject("venue")) : null).setLatitude(JSONUtils.getStringOrNull(jsonObject, "lat")).setLongitude(JSONUtils.getStringOrNull(jsonObject, "lng")).setAccess(access).setFirmwareVersion(JSONUtils.getStringOrNull(jsonObject, "firmware")).setInstanceId(JSONUtils.getStringOrNull(jsonObject, "instanceId")).setUrl(hexedUrl != null ? EddystoneUtils.fromHexedUrlToUrl(hexedUrl) : null).setNamespace(JSONUtils.getStringOrNull(jsonObject, "namespace")).setDeviceType(deviceType);
            if (profiles != null) {
                ArrayList<DeviceProfile> deviceProfileList = new ArrayList<DeviceProfile>();
                int profilesLength = profiles.length();
                for (int i = 0; i < profilesLength; ++i) {
                    deviceProfileList.add(DeviceProfile.valueOf((String)profiles.get(i)));
                }
                builder.addDeviceProfiles(deviceProfileList);
            }
            return builder.build();
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int getWifiScanInterval() {
        return this.wifiScanInterval;
    }

    @Override
    public int getBLEScanDuration() {
        return this.bleScanDuration;
    }

    @Override
    public ICloudBeacon.WorkingMode getWorkingMode() {
        return this.workingMode;
    }

    @Override
    public String getDefaultSSIDAuth() {
        return this.defaultSSIDAuth;
    }

    @Override
    public String getMaintenanceStart() {
        return this.maintenanceStartTime;
    }

    @Override
    public int getDataSendInterval() {
        return this.dataSendInterval;
    }

    @Override
    public String getDefaultSSIDCrypt() {
        return this.defaultSSIDCrypt;
    }

    @Override
    public int getBleScanInterval() {
        return this.bleScanInterval;
    }

    @Override
    public String getDefaultSSIDName() {
        return this.defaultSSIDName;
    }

    @Override
    public String getMaintenanceEnd() {
        return this.maintenanceEndTime;
    }

    @Override
    public ICloudBeacon.HashingPolicy getHashingPolicy() {
        return this.hashingPolicy;
    }

    @Override
    public boolean isShuffled() {
        return false;
    }

    @Override
    public UUID getSecureProximityUUID() {
        return null;
    }

    @Override
    public String getSecureNamespace() {
        return null;
    }

    @Override
    protected void parcelProperties(Bundle bundle) {
        bundle.putInt("wifiScanInterval", this.getWifiScanInterval());
        bundle.putInt("bleScanDuration", this.getBLEScanDuration());
        bundle.putSerializable("workingMode", (Serializable)((Object)this.getWorkingMode()));
        bundle.putSerializable("hashingPolicy", (Serializable)((Object)this.getHashingPolicy()));
        bundle.putString("defaultSSIDAuth", this.getDefaultSSIDAuth());
        bundle.putString("maintenanceStart", this.getMaintenanceStart());
        bundle.putInt("dataSendInterval", this.getDataSendInterval());
        bundle.putString("defaultSSIDCrypt", this.getDefaultSSIDCrypt());
        bundle.putInt("bleScanInterval", this.getBleScanInterval());
        bundle.putString("defaultSSIDName", this.getDefaultSSIDName());
        bundle.putString("maintenanceEnd", this.getMaintenanceEnd());
    }

    public static class Builder
    extends Device.Builder<CloudBeacon, Builder> {
        int wifiScanInterval;
        int bleScanDuration;
        ICloudBeacon.WorkingMode workingMode;
        String defaultSSIDAuth;
        String maintenanceStartTime;
        int dataSendInterval;
        String defaultSSIDCrypt;
        int bleScanInterval;
        String defaultSSIDName;
        String maintenanceEndTime;
        ICloudBeacon.HashingPolicy hashingPolicy;

        public Builder setWifiScanInterval(int wifiScanInterval) {
            this.wifiScanInterval = wifiScanInterval;
            return this;
        }

        public Builder setBleScanDuration(int bleScanDuration) {
            this.bleScanDuration = bleScanDuration;
            return this;
        }

        public Builder setWorkingMode(ICloudBeacon.WorkingMode workingMode) {
            this.workingMode = workingMode;
            return this;
        }

        public Builder setDefaultSSIDAuth(String defaultSSIDAuth) {
            this.defaultSSIDAuth = defaultSSIDAuth;
            return this;
        }

        public Builder setMaintenanceStart(String maintenanceStartTime) {
            this.maintenanceStartTime = maintenanceStartTime;
            return this;
        }

        public Builder setHashingPolicy(ICloudBeacon.HashingPolicy hashingPolicy) {
            this.hashingPolicy = hashingPolicy;
            return this;
        }

        public Builder setDataSendInterval(int dataSendInterval) {
            this.dataSendInterval = dataSendInterval;
            return this;
        }

        public Builder setDefaultSSIDCrypt(String defaultSSIDCrypt) {
            this.defaultSSIDCrypt = defaultSSIDCrypt;
            return this;
        }

        public Builder setBleScanInterval(int bleScanInterval) {
            this.bleScanInterval = bleScanInterval;
            return this;
        }

        public Builder setDefaultSSIDName(String defaultSSIDName) {
            this.defaultSSIDName = defaultSSIDName;
            return this;
        }

        public Builder setMaintenanceEnd(String maintenanceEndTime) {
            this.maintenanceEndTime = maintenanceEndTime;
            return this;
        }

        @Override
        public CloudBeacon build() {
            return new CloudBeacon(this);
        }
    }
}

