/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.model.AbstractModel;
import com.kontakt.sdk.android.common.model.Beacon;
import com.kontakt.sdk.android.common.model.IAction;
import com.kontakt.sdk.android.common.model.IBrowserAction;
import com.kontakt.sdk.android.common.model.IDevice;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.JSONUtils;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import java.io.Serializable;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class BrowserAction
extends AbstractModel
implements IBrowserAction {
    private final UUID id;
    private final Proximity proximity;
    private final IDevice device;
    private final String url;
    private final int hashCode;
    public static final Parcelable.Creator<BrowserAction> CREATOR = new Parcelable.Creator<BrowserAction>(){

        public BrowserAction createFromParcel(Parcel in) {
            Builder builder = new Builder();
            Bundle bundle = in.readBundle(this.getClass().getClassLoader());
            if (bundle.getBoolean("parcelable_has_beacon")) {
                builder.setDevice((IDevice)Beacon.CREATOR.createFromParcel(in));
            }
            return builder.setId((UUID)bundle.getSerializable("id")).setProximity((Proximity)((Object)bundle.getSerializable("proximity"))).setUrl(bundle.getString("url")).setDatabaseId(bundle.getInt("databaseId")).build();
        }

        public BrowserAction[] newArray(int size) {
            return new BrowserAction[size];
        }
    };

    private BrowserAction(Builder builder) {
        super(builder.databaseId);
        this.id = builder.id;
        this.proximity = builder.proximity;
        this.device = builder.beacon;
        this.url = builder.url;
        this.hashCode = HashCodeBuilder.init().append(this.id).append((Object)this.proximity).append(this.url).append(this.device).build();
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public Proximity getProximity() {
        return this.proximity;
    }

    @Override
    public IAction.ActionType getType() {
        return IAction.ActionType.BROWSER;
    }

    @Override
    public IDevice getDevice() {
        return this.device;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof BrowserAction)) {
            return false;
        }
        BrowserAction browserAction = (BrowserAction)o;
        return SDKEqualsBuilder.start().equals(this.id, browserAction.id).equals((Object)this.proximity, (Object)browserAction.proximity).equals(this.url, browserAction.url).equals(this.device, browserAction.device).result();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putSerializable("id", (Serializable)this.id);
        bundle.putSerializable("proximity", (Serializable)((Object)this.proximity));
        bundle.putParcelable("device", (Parcelable)this.device);
        bundle.putString("url", this.url);
        bundle.putInt("databaseId", this.databaseId);
        boolean shouldParcelBeacon = flags != 2 && this.device != null;
        bundle.putBoolean("parcelable_has_beacon", shouldParcelBeacon);
        dest.writeBundle(bundle);
        if (shouldParcelBeacon) {
            this.device.writeToParcel(dest, 4);
        }
    }

    public static BrowserAction from(JSONObject jsonObject) {
        try {
            return new Builder().setProximity(JSONUtils.hasJSONKey(jsonObject, "proximity") ? Proximity.valueOf(jsonObject.getString("proximity")) : null).setDevice(JSONUtils.hasJSONKey(jsonObject, "device") ? Beacon.from(jsonObject.getJSONObject("device")) : null).setUrl(JSONUtils.getStringOrNull(jsonObject, "url")).setId(JSONUtils.getUUIDOrNull(jsonObject, "id")).build();
        }
        catch (JSONException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static class Builder {
        private UUID id;
        private Proximity proximity;
        private IDevice beacon;
        private String url;
        private int databaseId;

        public Builder setDatabaseId(int databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder setId(UUID id) {
            this.id = id;
            return this;
        }

        public Builder setProximity(Proximity proximity) {
            this.proximity = proximity;
            return this;
        }

        public Builder setDevice(IDevice beacon) {
            this.beacon = beacon;
            return this;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public BrowserAction build() {
            return new BrowserAction(this);
        }
    }
}

