/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.JSONUtils;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BeaconId
implements Parcelable {
    public static final Parcelable.Creator<BeaconId> CREATOR = new Parcelable.Creator<BeaconId>(){

        public BeaconId createFromParcel(Parcel source) {
            return new BeaconId(source);
        }

        public BeaconId[] newArray(int size) {
            return new BeaconId[size];
        }
    };
    private static final String PROXIMITY = "proximity";
    private static final String MAJOR = "major";
    private static final String MINOR = "minor";
    private static final String FUTURE_SHUFFLES = "futureId";
    private static final String IBEACON = "IBEACON";
    private UUID proximity;
    private int major;
    private int minor;
    private Integer hashCode = null;

    public static BeaconId of(UUID proximity, int major, int minor) {
        return new BeaconId(proximity, major, minor);
    }

    private BeaconId(UUID proximity, int major, int minor) {
        this.proximity = proximity;
        this.major = major;
        this.minor = minor;
    }

    private BeaconId(Parcel source) {
        Bundle bundle = source.readBundle(this.getClass().getClassLoader());
        this.proximity = (UUID)bundle.getSerializable(PROXIMITY);
        this.major = bundle.getInt(MAJOR);
        this.minor = bundle.getInt(MINOR);
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMajor() {
        return this.major;
    }

    public UUID getProximity() {
        return this.proximity;
    }

    public String toString() {
        return this.proximity.toString() + ":" + this.major + ":" + this.minor;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof BeaconId)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        BeaconId beaconId = (BeaconId)o;
        return SDKEqualsBuilder.start().equals(this.proximity, beaconId.proximity).equals(this.major, beaconId.major).equals(this.minor, beaconId.minor).result();
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = HashCodeBuilder.init().append(this.proximity).append(this.major).append(this.minor).build();
        }
        return this.hashCode;
    }

    public static BeaconId of(IBeaconDevice beaconDevice) {
        UUID proximity = beaconDevice.getProximityUUID();
        int major = beaconDevice.getMajor();
        int minor = beaconDevice.getMinor();
        return new BeaconId(proximity, major, minor);
    }

    public static BeaconId fromQueriedBy(String queriedBy) {
        if (queriedBy == null) {
            throw new NullPointerException("queriedBy is null");
        }
        String[] split = queriedBy.split(":");
        if (split.length != 3) {
            throw new IllegalArgumentException("queriedBy is not valid format");
        }
        UUID proximity = UUID.fromString(split[0]);
        int major = Integer.parseInt(split[1]);
        int minor = Integer.parseInt(split[2]);
        return new BeaconId(proximity, major, minor);
    }

    public static BeaconId fromJSONObject(JSONObject jsonObject) {
        UUID proximity = JSONUtils.getUUIDOrNull(jsonObject, PROXIMITY);
        if (proximity == null) {
            throw new IllegalStateException("proximity is not present in the response");
        }
        int major = JSONUtils.getInt(jsonObject, MAJOR, -1);
        if (major == -1) {
            throw new IllegalStateException("major is not present in the response");
        }
        int minor = JSONUtils.getInt(jsonObject, MINOR, -1);
        if (minor == -1) {
            throw new IllegalStateException("minor is not present in the response");
        }
        return new BeaconId(proximity, major, minor);
    }

    public static List<BeaconId> getIBeaconFutureIds(JSONObject jsonObject) {
        ArrayList<BeaconId> beaconIds = new ArrayList<BeaconId>();
        try {
            JSONObject futureShufflesObject = jsonObject.getJSONObject(FUTURE_SHUFFLES);
            JSONArray ibeaconFutureShuffles = futureShufflesObject.getJSONArray(IBEACON);
            for (int i = 0; i < ibeaconFutureShuffles.length(); ++i) {
                JSONObject ibeaconFutureShufflesJSONObject = ibeaconFutureShuffles.getJSONObject(i);
                beaconIds.add(BeaconId.fromJSONObject(ibeaconFutureShufflesJSONObject));
            }
        }
        catch (JSONException e) {
            throw new IllegalStateException("futureIds is not present in the response");
        }
        return beaconIds;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putSerializable(PROXIMITY, (Serializable)this.proximity);
        bundle.putInt(MAJOR, this.major);
        bundle.putInt(MINOR, this.minor);
        dest.writeBundle(bundle);
    }
}

