/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.Access;
import com.kontakt.sdk.android.common.model.Device;
import com.kontakt.sdk.android.common.model.DeviceType;
import com.kontakt.sdk.android.common.model.IBeacon;
import com.kontakt.sdk.android.common.model.Model;
import com.kontakt.sdk.android.common.model.Specification;
import com.kontakt.sdk.android.common.model.Venue;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.util.EddystoneUtils;
import com.kontakt.sdk.android.common.util.JSONUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Beacon
extends Device
implements IBeacon {
    private final boolean shuffled;
    private final UUID secureProximityUUID;
    private final String secureNamespace;
    public static final Parcelable.Creator<Beacon> CREATOR = new Parcelable.Creator<Beacon>(){

        public Beacon createFromParcel(Parcel in) {
            Bundle bundle = in.readBundle(this.getClass().getClassLoader());
            return new Beacon(bundle, in);
        }

        public Beacon[] newArray(int size) {
            return new Beacon[size];
        }
    };

    private Beacon(Bundle bundle, Parcel parcel) {
        super(bundle, parcel);
        this.shuffled = bundle.getBoolean("shuffled");
        this.secureProximityUUID = (UUID)bundle.getSerializable("secureProximity");
        this.secureNamespace = bundle.getString("secureNamespace");
    }

    public Beacon(Builder builder) {
        super(builder);
        this.shuffled = builder.shuffled;
        this.secureProximityUUID = builder.secureProximityUUID;
        this.secureNamespace = builder.secureNamespace;
    }

    @Override
    public boolean isShuffled() {
        return this.shuffled;
    }

    @Override
    public UUID getSecureProximityUUID() {
        return this.secureProximityUUID;
    }

    @Override
    public String getSecureNamespace() {
        return this.secureNamespace;
    }

    @Override
    protected void parcelProperties(Bundle bundle) {
        bundle.putBoolean("shuffled", this.shuffled);
        bundle.putSerializable("secureProximity", (Serializable)this.secureProximityUUID);
        bundle.putString("secureNamespace", this.secureNamespace);
    }

    public static Beacon from(JSONObject jsonObject) {
        Access access = Access.valueOf(JSONUtils.getStringOrNull(jsonObject, "access"));
        Specification specification = Specification.valueOf(JSONUtils.getStringOrNull(jsonObject, "specification"));
        Model model = Model.valueOf(JSONUtils.getStringOrNull(jsonObject, "model"));
        String hexedUrl = JSONUtils.getStringOrNull(jsonObject, "url");
        DeviceType deviceType = DeviceType.valueOf(JSONUtils.getStringOrNull(jsonObject, "deviceType"));
        UUID secureProximityUUID = JSONUtils.getUUIDOrNull(jsonObject, "secureProximity");
        String secureNamespace = JSONUtils.getStringOrNull(jsonObject, "secureNamespace");
        try {
            JSONArray profiles = jsonObject.optJSONArray("profiles");
            Builder builder = new Builder();
            builder.setShuffled(JSONUtils.getBoolean(jsonObject, "shuffled", false)).setSecureProximityUUID(secureProximityUUID).setSecureNamespace(secureNamespace).setId(JSONUtils.getUUIDOrNull(jsonObject, "id")).setProximityUUID(JSONUtils.getUUIDOrNull(jsonObject, "proximity")).setMajor(JSONUtils.getInt(jsonObject, "major", 0)).setMinor(JSONUtils.getInt(jsonObject, "minor", 0)).setMacAddress(JSONUtils.getString(jsonObject, "mac", "")).setTxPower(JSONUtils.getInt(jsonObject, "txPower", -1)).setName(JSONUtils.getStringOrNull(jsonObject, "name")).setAlias(JSONUtils.getStringOrNull(jsonObject, "alias")).setInterval(JSONUtils.getInt(jsonObject, "interval", 0)).setUniqueId(JSONUtils.getString(jsonObject, "uniqueId", "")).setActionsCount(JSONUtils.getInt(jsonObject, "actionsCount", 0)).setManagerId(JSONUtils.getUUIDOrNull(jsonObject, "managerId")).setVenue(JSONUtils.hasJSONKey(jsonObject, "venue") ? Venue.from(jsonObject.getJSONObject("venue")) : null).setLatitude(JSONUtils.getStringOrNull(jsonObject, "lat")).setLongitude(JSONUtils.getStringOrNull(jsonObject, "lng")).setAccess(access).setSpecification(specification).setModel(model).setFirmwareVersion(JSONUtils.getStringOrNull(jsonObject, "firmware")).setInstanceId(JSONUtils.getStringOrNull(jsonObject, "instanceId")).setUrl(hexedUrl != null ? EddystoneUtils.fromHexedUrlToUrl(hexedUrl) : null).setNamespace(JSONUtils.getStringOrNull(jsonObject, "namespace")).setDeviceType(deviceType);
            if (profiles != null) {
                ArrayList<DeviceProfile> deviceProfileList = new ArrayList<DeviceProfile>();
                int profilesLength = profiles.length();
                for (int i = 0; i < profilesLength; ++i) {
                    deviceProfileList.add(DeviceProfile.valueOf((String)profiles.get(i)));
                }
                builder.addDeviceProfiles(deviceProfileList);
            }
            return builder.build();
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    public static class Builder
    extends Device.Builder<Beacon, Builder> {
        private boolean shuffled = false;
        private UUID secureProximityUUID;
        private String secureNamespace;

        public Builder setShuffled(boolean shuffled) {
            this.shuffled = shuffled;
            return this;
        }

        public Builder setSecureProximityUUID(UUID secureProximityUUID) {
            this.secureProximityUUID = secureProximityUUID;
            return this;
        }

        public Builder setSecureNamespace(String secureNamespace) {
            this.secureNamespace = secureNamespace;
            return this;
        }

        @Override
        public Beacon build() {
            return new Beacon(this);
        }
    }
}

