package com.kontakt.sdk.android.common.util;

/**
 * Content category describes a kind of the content of Content Action.
 */
public enum ContentCategory {
    /**
     * The IMAGE indicates that content is an image file. Supported formats: jpeg, gif, png.
     */
    IMAGE,
    /**
     * The AUDIO indicates that content is an audio file. Supported formats: mp3.
     */
    AUDIO,
    /**
     * The VIDEO indicates that content is a video file. Supported formats: mp4.
     */
    VIDEO,
    /**
     * The TEXT indicates that content is a plain text.
     */
    TEXT,
    /**
     * The UNKNOWN content category.
     */
    UNKNOWN;
}
