package com.kontakt.sdk.android.common.profile;

import android.os.Parcel;

import java.util.ArrayList;
import java.util.List;

/**
 * Currently supported remote bluetooth device profiles by kontakt.io Android SDK.
 */
public enum DeviceProfile {
    IBEACON(0x01),
    EDDYSTONE(0x02);

    final int activeProfileValue;

    DeviceProfile(final int activeProfileValue) {
        this.activeProfileValue = activeProfileValue;
    }

    public int getActiveProfileValue() {
        return activeProfileValue;
    }

    public static void writeToParcel(Parcel dest, List<DeviceProfile> deviceProfiles) {
        List<String> deviceProfilesString = new ArrayList<String>();
        for (DeviceProfile deviceProfile : deviceProfiles) {
            deviceProfilesString.add(deviceProfile.name());
        }
        dest.writeList(deviceProfilesString);
    }

    public static List<DeviceProfile> readFromParcel(Parcel in) {
        List<DeviceProfile> deviceProfileList = new ArrayList<DeviceProfile>();
        List<String> deviceProfilesString = new ArrayList<String>();
        in.readList(deviceProfilesString, null);

        for (String name : deviceProfilesString) {
            deviceProfileList.add(valueOf(name));
        }

        return deviceProfileList;
    }

    public static DeviceProfile getActiveProfile(final int activeProfile) {
        for(DeviceProfile deviceProfile : values()) {
            if(deviceProfile.activeProfileValue == activeProfile) {
                return deviceProfile;
            }
        }

        return null;
    }
}
