package com.kontakt.sdk.android.common.model;

import com.kontakt.sdk.android.common.util.Constants;
import com.kontakt.sdk.android.common.util.JSONUtils;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class SecureCommandResponse {

    private final String config;
    private final String uniqueId;

    private SecureCommandResponse(String config, String uniqueId) {
        this.config = config;
        this.uniqueId = uniqueId;
    }

    public String getConfig() {
        return config;
    }

    public String getUniqueId() {
        return uniqueId;
    }

    public static SecureCommandResponse from(final JSONObject jsonObject) {
        String config = JSONUtils.getStringOrNull(jsonObject, Constants.Commands.CONFIG);
        String uniqueId = JSONUtils.getStringOrNull(jsonObject, Constants.Commands.UNIQUE_ID);
        return new SecureCommandResponse(config, uniqueId);
    }

    public static List<SecureCommandResponse> fromList(final JSONObject jsonObject) {
        try {
            List<SecureCommandResponse> secureCommandResponses = new ArrayList<SecureCommandResponse>();
            JSONArray jsonArray = jsonObject.getJSONArray(Constants.Commands.COMMANDS);
            int commandsSize = jsonArray.length();
            for (int i = 0; i < commandsSize; i++) {
                secureCommandResponses.add(from(jsonArray.getJSONObject(i)));
            }
            return secureCommandResponses;
        } catch (Exception e) {
            throw new IllegalStateException("No commands found");
        }
    }
}
