package com.kontakt.sdk.android.common.model;

import java.util.List;
import java.util.UUID;

/**
 * Venue acts as Region.
 * Additionally it is a describable container for Devices which can be signified
 * with image cover.
 */
public interface IVenue extends IBrandedPlace {

    /**
     * Gets id.
     *
     * @return the id
     */
    UUID getId();

    /**
     * Gets beacons count.
     *
     * @return the beacons count
     */
    int getDevicesCount();

    /**
     * Gets cover type.
     *
     * @return the cover type
     */
    String getCoverType();

    /**
     * Gets beacons.
     *
     * @return the beacons
     */
    List<IDevice> getDevices();

    /**
     * Gets Manager Id.
     *
     * @return the managers
     */
    UUID getManagerId();

    /**
     * Gets latitude.
     *
     * @return the latitude
     */
    String getLatitude();

    /**
     * Gets longitude.
     *
     * @return the longitude
     */
    String getLongitude();
}
