package com.kontakt.sdk.android.common.model;

import java.util.UUID;

/**
 * Represents Proximity for IBeacon devices
 */
public interface IProximityUUID {
    /**
     * Gets proximity
     *
     * @return the proximity
     */
    UUID getProximity();

    /**
     * Gets secure proximity
     *
     * @return the proximity
     */
    UUID getSecureProximity();

    /**
     * Checks if proximity is shuffled or not
     *
     * @return true or false
     */
    boolean isShuffled();

    /**
     * Checks if proximity is shared to you
     * @return true if this proximity is shared to you by other user
     */
    boolean isShared();
}
