package com.kontakt.sdk.android.common.model;

import java.util.UUID;

/**
 * Preset describes the predefined set of parameters that Beacon can be
 * configured with. Contrary to Configs, Profiles are not removed once the Beacon
 * device will be updated with parameters applied from them. They should be
 * interpreted as states in which Beacon devices are working. For example, you
 * could define "Long interval profile" where device interval period accepts the
 * the longest interval.
 */
public interface IPreset extends IModel {

    /**
     * Gets proximity uUID.
     *
     * @return the proximity uUID
     */
    UUID getProximityUUID();

    /**
     * Gets interval.
     *
     * @return the interval
     */
    int getInterval();

    /**
     * Gets tx power.
     *
     * @return the tx power
     */
    int getTxPower();

    /**
     * Gets name.
     *
     * @return the name
     */
    String getName();

    /**
     * Gets description.
     *
     * @return the description
     */
    String getDescription();
}
